<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers access to a number of publication related actions.
After performing the action, the browser will return to the specified $return page.

actions:
  - new (via POST)
  - edit (via POST)
  - delete (via POST)
*/

require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

include_once($DIR."_basicfunctions.php");
include_once($DIR."lib/actions/authoractions.php");

# register relevant REQUEST parameters
$action = "";
if (isset($_REQUEST["action"])) {
    $action = $_REQUEST["action"];
} 
if (get_magic_quotes_gpc()==1) {
    $action = stripslashes($action);
}

$ID = "";
if (isset($_REQUEST["ID"])) {
    $ID = $_REQUEST["ID"];
}
$return = "";
if (isset($_REQUEST["return"])) {
    $return = $_REQUEST["return"];
}
$submitType = "";
if (isset($_REQUEST["submittype"])) {
    $submitType = $_REQUEST["submittype"];
}

#depending on specified action, perform it...
switch ($action) {
  
  case "new":
    include_once($DIR."lib/functions/authorfunctions.php");
    
    $authorArray = array();
    getAuthorArrayFromSubmit($authorArray);
    
    $bRepost = false;
    $submitCheck = checkSubmittedAuthorFields($authorArray); //-1: duplicates found, -2: empty name
    if (($submitCheck != 0) && ($authorArray['confirm'] != 'TRUE'))
    { 
      if ($submitCheck == -2)
      {
        $authorArray['confirm'] = "TRUE";
      }
      
      $authorArray['submittype'] = "change";
      $bRepost = true;
    }
    
    if ($bRepost)
    {
      authorRepost($authorArray);
    }
    else
    {
      $ID = authorSubmit($authorArray);
      
      if ($ID != -1) {
        echo '<script type="text/javascript">';
        echo 'if (window.opener.AUTHORS) {';
        echo '  window.opener.AUTHORS['.$ID.']="'.getCleanNameFromRow($authorArray).'";';
      	echo '  window.opener.AuthorSearch();';
	      echo '  window.close();';
	      echo '}';
	      echo '</script>';

        global $URL;
        returnTo($URL."index.php?page=author&kind=single&ID=".$ID);
      }
    }
    returnTo(rawurldecode($authorArray['return']));
    break;
 
  case "edit":
    include_once($DIR."lib/functions/authorfunctions.php");
    
    $authorArray = array();
    getAuthorArrayFromSubmit($authorArray);
    
    $bRepost = false;
    $submitCheck = checkSubmittedAuthorFields($authorArray); //-1: duplicates found, -2: empty name
    if (($submitCheck != 0) && ($authorArray['confirm'] != 'TRUE'))
    { 
      if ($submitCheck == -2)
      {
        $authorArray['confirm'] = "TRUE";
      }
      
      $authorArray['submittype'] = "change";
      $bRepost = true;
    }

    if ($bRepost)
    {
      authorRepost($authorArray);
      break;
    }
    else
    {
      authorUpdate($authorArray);
    }
    
    returnTo(rawurldecode($authorArray['return']));
    break;

  case "delete":
    authorDelete($ID);
    returnTo(rawurldecode($return));
    break;
    
  default:
    break;
  
    
}

?>