<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers access to a number of publication related actions.
After performing the action, the browser will return to the specified $return page.

actions:
  - addtotopic ($pub_ids, $topic_id)
  - removefromtopic ($pub_ids, $topic_id)
*/

require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

include_once($DIR."_basicfunctions.php");
include_once($DIR."lib/actions/multipublicationactions.php");

# register relevant REQUEST parameters
$action = "";
if (isset($_REQUEST["action"])) {
    $action = $_REQUEST["action"];
} 
if (get_magic_quotes_gpc()==1) {
    $action = stripslashes($action);
}

$pub_ids = "";
if (isset($_REQUEST["pub_ids"])) {
    $pub_ids = $_REQUEST["pub_ids"];
}
$return = "";
if (isset($_REQUEST["return"])) {
    $return = $_REQUEST["return"];
}
$topic_id = "";
if (isset($_REQUEST["topic_id"])) {
  $topic_id = $_REQUEST["topic_id"];
}


#depending on specified action, perform it...
switch ($action) {
  case "addtotopic":
    if ((sizeof($pub_ids)==0)||($pub_ids=="")) {
        $_SESSION["aigaionmessage"] .= "No publications were selected.<br>";
    } else {
        publicationMultipleAddToTopic($pub_ids, $topic_id);
    }
    returnTo(rawurldecode($return));
    break;
  case "removefromtopic":
    if ((sizeof($pub_ids)==0)||($pub_ids=="")) {
        $_SESSION["aigaionmessage"] .= "No publications were selected.<br>";
    } else {
        publicationMultipleRemoveFromTopic($pub_ids, $topic_id);
    }
    returnTo(rawurldecode($return));
    break;
    
}

?>