<?php
/*
This file offers access to a number of reader note related actions.
After performing the action, the browser will return to the specified $return page.

actions:
    delete(note_id, confirmed, return)
    add(text, pub_id, person_id, return) 
    change(note_id, text, rights, return) 
    setrights(note_id, rights, return) 
    //other shortcut change actions, such as 'settext', can be added...
*/

require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

include_once($DIR."_basicfunctions.php");
include_once($DIR."lib/actions/noteactions.php");

# register relevant REQUEST parameters
$errormessage = "";
$action = "";
if (isset($_REQUEST["action"])) {
    $action = $_REQUEST["action"];
}
if (get_magic_quotes_gpc()==1) {
    $action = stripslashes($action);
}
$note_id = "";
if (isset($_REQUEST["note_id"])) {
    $note_id = $_REQUEST["note_id"];
}
$pub_id = "";
if (isset($_REQUEST["pub_id"])) {
    $pub_id = $_REQUEST["pub_id"];
}
$confirmed = "";
if (isset($_REQUEST["confirmed"])) {
    $confirmed = $_REQUEST["confirmed"];
}
$text = "";
if (isset($_REQUEST["text"])) {
    $text = $_REQUEST["text"];
}
if (get_magic_quotes_gpc()==1) {
    $text = stripslashes($text);
}
$person_id = "person_id";
if (isset($_REQUEST["person_id"])) {
    $person_id = $_REQUEST["person_id"];
}
$rights = "";
if (isset($_REQUEST["rights"])) {
    $rights = $_REQUEST["rights"];
}
$return = "";
if (isset($_REQUEST["return"])) {
    $return = $_REQUEST["return"];
}
if (get_magic_quotes_gpc()==1) {
    $return = stripslashes($return);
}

#depending on specified action, perform it...
switch ($action) {
    case "delete": //delete(note_id, confirmed, return)
        #delete.  check whether confirmed is True. If so, delete
        if ($confirmed) {
            //delete, return
            $success = noteDelete($note_id);
            if($success)$_SESSION["aigaionmessage"].="Note deleted.<br>";
            returnTo(rawurldecode($return)."&note_id=".$note_id);
        } else {
            //do nothing. It seems to be the case that we don't even get here if confirmed was false...
            $_SESSION["aigaionerror"].="Something strange happened: we're in actionnote#delete, but confirm is false!.<br>";
            returnTo(rawurldecode($return)."&note_id=".$note_id);
        }
        break;
    case "add": //add(text, pub_id, person_id, return) 
        if ($text && ($text!="")) {
            $success = noteAddNew($pub_id, $_SESSION["personID"], $text);
            if($success)$_SESSION["aigaionmessage"].="Note added.<br>";
            returnTo(rawurldecode($return));
        } else {
            $_SESSION["aigaionmessage"].="Empty note: not added.<br>";
            returnTo(rawurldecode($return));
        }
        break;
    case "change": // change(note_id, text, rights, return) 
        $success = noteChange($note_id, $person_id, $text, $rights);
        if($success)$_SESSION["aigaionmessage"].="Note changed.<br>";
        returnTo(rawurldecode($return)."&note_id=".$note_id);
        break;
    case "setrights": // setrights(note_id, rights, return) 
        $success = noteChangeRights($note_id, $rights);
        if($success)$_SESSION["aigaionmessage"].="Note changed.<br>";
        returnTo(rawurldecode($return)."&note_id=".$note_id);
        break;
}

?>