<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers access to a number of publication related actions.
After performing the action, the browser will return to the specified $return page.

actions:
  - addmark ($pub_id, $mark)
  - unread ($pub_id)
  - new (via POST)
  - edit (via POST)
  - delete (via POST)
*/

require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

include_once($DIR."_basicfunctions.php");
include_once($DIR."lib/actions/publicationactions.php");
include_once($DIR."lib/actions/attachmentactions.php");

# register relevant REQUEST parameters
$action = "";
if (isset($_REQUEST["action"])) {
    $action = $_REQUEST["action"];
} 
if (get_magic_quotes_gpc()==1) {
    $action = stripslashes($action);
}

$pub_id = "";
if (isset($_REQUEST["pub_id"])) {
    $pub_id = $_REQUEST["pub_id"];
}
$return = "";
if (isset($_REQUEST["return"])) {
    $return = $_REQUEST["return"];
}
$mark = "";
if (isset($_REQUEST["mark"])) {
  $mark = $_REQUEST["mark"];
}

$submitType = "";
if (isset($_REQUEST["submittype"])) {
    $submitType = $_REQUEST["submittype"];
}
$alternativename = "";
if (isset($_REQUEST["alternativename"])) {
    $alternativename = $_REQUEST["alternativename"];
}


#depending on specified action, perform it...
switch ($action) {
  case "addmark":
    publicationAddMark($pub_id, $mark);
    returnTo(rawurldecode($return));
    break;

  case "unread": 
    publicationUnread($pub_id);
    returnTo(rawurldecode($return));
    break;
        
  case "new":
    $publicationArray = array();
    getPublicationArrayFromSubmit($publicationArray);
    
    $bRepost = false;
    if ($submitType == "change")
    {
      $bRepost = true;
    }
    else if (checkSubmittedPublicationFields($publicationArray) != 0)
    { 
      $publicationArray['submittype'] = "change";
      $bRepost = true;
    }
    
    if ($bRepost)
    {
      publicationRepost($publicationArray);
    }
    else
    {
      $pub_id = publicationSubmit($publicationArray);
      
      if (is_uploaded_file($_FILES['upload']['tmp_name'])) {
        $success = attachmentAddNew($pub_id, "", $alternativename, TRUE);
        if ($success) {
          $_SESSION["aigaionmessage"].="Attachment added.<br>";
        } else {
          $_SESSION["aigaionerror"].="An error occurred while uploading the new attachment.<br>";
        }
      }
      if ($pub_id != -1) {
        global $URL;
        returnTo($URL."index.php?page=publication&kind=single&ID=".$pub_id);
      }
      returnTo(rawurldecode($publicationArray['return']));
    }
      
    break;
  
  case "edit":
    $publicationArray = array();
    getPublicationArrayFromSubmit($publicationArray);
    
    $bRepost = false;
    if ($submitType == "change")
    {
      $bRepost = true;
    }
    else 
    { 
      $check = checkSubmittedPublicationFields($publicationArray);
      if ($check < 0)
      {
        if ($check == -3)
        {
          $publicationArray['action'] = "confirm";
        }
        $publicationArray['submittype'] = "change";
        $bRepost = true;
      }
    }
    
    if ($bRepost)
    {
      publicationRepost($publicationArray);
      break;
    }
    else
    {
      publicationUpdate($publicationArray);
      if (is_uploaded_file($_FILES['upload']['tmp_name'])) {
        $success = attachmentAddNew($pub_id, "", $alternativename, TRUE);
        if ($success) {
          $_SESSION["aigaionmessage"].="Attachment added.<br>";
        } else {
          $_SESSION["aigaionerror"].="An error occurred while uploading the new attachment.<br>";
        }
      }
      returnTo(rawurldecode($publicationArray['return']));
    }
    
    break;
  case "confirm":
    $publicationArray = array();
    getPublicationArrayFromSubmit($publicationArray);
    
    $upd_crossref = "N";
    if (isset($_REQUEST["upd_crossref"])) {
      $upd_crossref = $_REQUEST["upd_crossref"];
    }
    
    publicationUpdate($publicationArray, $upd_crossref);
    if (is_uploaded_file($_FILES['upload']['tmp_name'])) {
      $success = attachmentAddNew($pub_id, "", $alternativename, TRUE);
      if ($success) {
        $_SESSION["aigaionmessage"].="Attachment added.<br>";
      } else {
        $_SESSION["aigaionerror"].="An error occurred while uploading the new attachment.<br>";
      }
    }
    returnTo(rawurldecode($publicationArray['return']));
  
    break;
  case "delete":
    publicationDelete($pub_id);
    returnTo(rawurldecode($return));
    break;
  
    
}

?>