<?php
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

/*
This file offers access to a number of topic related actions.
After performing the action, the browser will return to the specified $return page.

actions:
    delete
    add
    change (removepubsfromoldancestors: if set, publications will be removed from the OLD ancestors of this topic when setting a new parent for this topic)
    setparent -- not yet implemented
    //other shortcut change actions, such as 'settext', can be added...
    
    setcollapsed 
    subscribe
    subscriberecursive
    unsubscribe
    unsubscriberemaining
    setstarred
    
*/


include_once($DIR."_basicfunctions.php");
include_once($DIR."lib/actions/topicactions.php");

# register relevant REQUEST parameters
$action = "";
if (isset($_REQUEST["action"])) {
    $action = $_REQUEST["action"];
}
if (get_magic_quotes_gpc()==1) {
    $action = stripslashes($action);
}
$topic_id = "";
if (isset($_REQUEST["topic_id"])) {
    $topic_id = $_REQUEST["topic_id"];
}
$confirmed = "";
if (isset($_REQUEST["confirmed"])) {
    $confirmed = $_REQUEST["confirmed"];
}
$description = "";
if (isset($_REQUEST["description"])) {
    $description = $_REQUEST["description"];
}
if (get_magic_quotes_gpc()==1) {
    $description = stripslashes($description);
}
$name = "";
if (isset($_REQUEST["name"])) {
    $name = $_REQUEST["name"];
}
if (get_magic_quotes_gpc()==1) {
    $name = stripslashes($name);
}
$url = "";
if (isset($_REQUEST["url"])) {
    $url = $_REQUEST["url"];
}
if (get_magic_quotes_gpc()==1) {
    $url = stripslashes($url);
}
$starred = 0;
if (isset($_REQUEST["starred"])) {
    $starred = 1;
}
$parent = 1;
if (isset($_REQUEST["parent"])) {
    $parent = $_REQUEST["parent"];
}
$removepubsfromoldancestors = FALSE;
if (isset($_REQUEST["removepubsfromoldancestors"])) {
    $removepubsfromoldancestors = TRUE;
}
$collapsed = "0";
if (isset($_REQUEST["collapsed"])) {
    $collapsed = $_REQUEST["collapsed"];
}
$return = "";
if (isset($_REQUEST["return"])) {
    $return = $_REQUEST["return"];
}
if (get_magic_quotes_gpc()==1) {
    $return = stripslashes($return);
}

#depending on specified action, perform it...
switch ($action) {
    case "delete": 
        #delete.  check whether confirmed is True. If so, delete, otherwise request confirmation
        if ($confirmed) {
            //delete, return
            topicDelete($topic_id);
            returnTo($URL);
        } else {
            //do nothing. It seems to be the case that we don't even get here if confirmed was false...
            $_SESSION["aigaionerror"].="Something strange happened: we're in actiontopic#delete, but confirm is false!.<br>";
            returnTo(rawurldecode($return));
        }
        break;
    case "add": 
        topicAdd($parent,$name,$description,$url);
        returnTo(rawurldecode($return));
        break;
    case "change": 
        topicChange($topic_id,$parent,$removepubsfromoldancestors,$name,$description,$url);
        topicSetStarred($topic_id, $_SESSION["personID"], $starred);
        returnTo(rawurldecode($return));
        break;
    case "setcollapsed":
        topicSetCollapsed($topic_id, $_SESSION["personID"], $collapsed) ;
        returnTo(rawurldecode($return));
        break;
    case "subscribe":
        topicSubscribe($topic_id, $_SESSION["personID"]);
        returnTo(rawurldecode($return));
        break;
    case "subscriberecursive":
        topicSubscribeRecursive($topic_id, $_SESSION["personID"]);
        returnTo(rawurldecode($return));
        break;
    case "unsubscribe":
        topicUnsubscribe($topic_id, $_SESSION["personID"]);
        returnTo(rawurldecode($return));
        break;
    case "unsubscriberemaining":
        topicUnsubscribeRemaining($_SESSION["personID"]);
        returnTo(rawurldecode($return));
        break;
    case "setstarred":
        topicSetStarred($topic_id,$_SESSION["personID"],$starred);
        returnTo(rawurldecode($return));
        break;
    
}

?>