<?php 
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
 Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/* 
This is the entrypoint for all author handling in aigaion.
For each kind, the required functions from the libraries are called.
  
  Supported kinds are:
  - single  for displaying a single author
  - list    for displaying a list of authors
    - all
    - topic

  - edit    for editting an author from the database
  - new     for creating a new author from scratch
  - delete  for deleting an author from the database
  
  - select  for selecting authors that belong to a publication
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

#Register request and session vars
$kind="";
if (isset($_REQUEST["kind"])) {
  $kind=$_REQUEST["kind"];
}

$return="";
if (isset($_REQUEST["return"])) {
  $return=rawurldecode($_REQUEST["return"]);
}
?>
<?php 
error_reporting(E_ERROR);

switch ($kind) {
  case "single":
    include_once($DIR."lib/displays/authordisplays.php");
    $ID = "";
    if (isset($_REQUEST["ID"])) {
      $ID = $_REQUEST["ID"];
    }
    
    echo getAuthorByID($ID);
    
    break;
  
  case "list":
    include_once($DIR."lib/displays/authordisplays.php");
    $type = "";
    if (isset($_REQUEST["type"])) {
      $type = $_REQUEST["type"];
    }
    
    echo getAuthorList($type);
    
    break;
  
  case "edit":
    include_once($DIR."lib/editforms/authoreditforms.php");
    $author_id = "";
    if (isset($_REQUEST["ID"])) {
      $author_id = $_REQUEST["ID"];
    }
    
    echo getAuthorForm($kind, $author_id, $return);
    break;
    
  case "new":
    include_once($DIR."lib/editforms/authoreditforms.php");
    echo getAuthorForm($kind, "", $return);
    
    break;
    
  case "delete":
    include_once($DIR."lib/editforms/authoreditforms.php");
    $author_id = "";
    if (isset($_REQUEST["ID"])) {
      $author_id = $_REQUEST["ID"];
    }
    
    echo getAuthorDeleteFormByID($author_id,$return);
    break;
    
  case "select":
    include_once($DIR."lib/editforms/authoreditforms.php");
    $pub_id = "";
    if (isset($_REQUEST["pub_id"])) {
      $pub_id = $_REQUEST["pub_id"];
    }
    
    $authors = "";
    if (isset($_REQUEST["authors"])) {
      $authors = $_REQUEST["authors"];
    }
    
    $editors = "";
    if (isset($_REQUEST["editors"])) {
      $editors = $_REQUEST["editors"];
    }
    
    echo getAuthorSelectionForm($pub_id, $authors, $editors);
    break;
    
  default:
    break;
}
?>
