<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/functions/exportfunctions.php");

#Register request and session vars
$action="";
if (isset($_REQUEST["action"])) {
    $action=$_REQUEST["action"];
}
$type="";
if (isset($_REQUEST["type"])) {
  $type=$_REQUEST["type"];
}
$initialsonly=False;
if (isset($_REQUEST["initialsonly"])) {
    $initialsonly=$_REQUEST["initialsonly"];
}
$exporttopics=False;
if (isset($_REQUEST["exporttopics"])) {
    $exporttopics=$_REQUEST["exporttopics"];
}
$allpublications=false;
if (isset($_REQUEST["allpublications"])) {
    $allpublications=$_REQUEST["allpublications"];
}
// To export bib-tex results to webpage for easy copy pasting if file create access is disabled
$exporttopage=False;
if (isset($_REQUEST["exporttopage"])) {
    $exporttopage=$_REQUEST["exporttopage"];
}
// To export bib-tex publication tree results to webpage for easy copy pasting if file create access is disabled
$exporttopagepublicationtree=False;
if (isset($_REQUEST["exporttopagepublicationtree"])) {
    $exporttopagepublicationtree=$_REQUEST["exporttopagepublicationtree"];
}


//generate based on settings...
if ($action=="generate") {
    //export papers
    $feedback = "<div class=message>Exporting publications...<br>";
    exportBufferStart();
    $Q=mysql_query("SELECT pub_id FROM publication ORDER BY bibtex_id");
    $bRis = false;
    if ($type == "ris") $bRis = true;
    while ($R = mysql_fetch_array($Q))
    {
        $pub_id = $R["pub_id"];
        $io = 'N';
        if ($initialsonly == True) {
            $io = 'Y';
        }
        if ($bRis)
        	exportRIS($pub_id, $io);
        else
        	exportBibtex($pub_id, $io);
    }
    
    //export topics
    if ($exporttopics==True) {
         //export topics. Don't export top.
        $feedback.="Exporting topic tree...<br>";
        $Q=mysql_query("SELECT * FROM topic");
        while ($R = mysql_fetch_array($Q)) {
            if ($R["ID"]!="1") {
                echo "@AIGAIONTOPIC{".$R["ID"].",\n  title={".$R["name"]."},\n  abstract={".$R["description"]."},\n  url={".$R["url"]."}\n}\n\n";
            }
        }
        //export topic links.
        $Q=mysql_query("SELECT * FROM topictopiclink");
        while ($R = mysql_fetch_array($Q)) {
            echo  "@AIGAIONTOPICTOPICLINK{\n  ";
            echo  "source={".$R["source_topic_id"]."},\n  ";
            echo  "target={".$R["target_topic_id"]."},\n  ";
			// GtB: Added topic names
			$Q2=mysql_query("SELECT * FROM topic WHERE ID=".$R["source_topic_id"]);
            $R2 = mysql_fetch_array($Q2);
            echo  "sourcename={".$R2["name"]."},\n  ";
			$linkindex=$R["target_topic_id"];
			$names="";
			$source=2;
			while ($source!=1)
			{

				$Q2=mysql_query("SELECT * FROM topic WHERE ID=".$linkindex);
				$R2 = mysql_fetch_array($Q2);
				if (empty($names))
				{
					$names=$R2["name"];
				}else
				{
					$names=$R2["name"]."|".$names;
				}	
		        $Q3=mysql_query("SELECT * FROM topictopiclink WHERE source_topic_id=".$linkindex);
				$R3 = mysql_fetch_array($Q3);
				$linkindex=$R3["target_topic_id"];
				if (empty($R3))
				{
					break;
				}else
				{
					$source=$R3["source_topic_id"];
				}
            }
            echo  "targetname={".$names."}  ";
            // End of topic names
            echo  "\n}\n\n";
        }
    }
    
    //save. 
    #DR: if server is write only, this should be exported to the screen instead of to the file
    if (getConfigSetting("SERVER_NOT_WRITABLE")=="TRUE") {
        $data = exportBufferEndNoBR();
        echo "\n<form>";
        echo "\n<table border=0>";
		echo "\n<tr><td>";
        echo "\n<textarea virtualcols=100 cols=80 rows=25>\n";
        echo $data;
        echo "\n</textarea>";
        echo "\n</td></tr>";
        echo "\n</table>";
        echo "\n</form>";
    } else {
        $feedback2=exportBufferFileEnd($FILEDIR."export.bib");
        $feedback .= "<br>Export finished. If the window with the exported BiBTeX does not open automatically, click <a href='".$FILEURL."export.bib' target='export_window'>here</a>.</div>";
    }
    ?>
   <form method="post">
    <table border=0>
    
    <tr>
    <td class=small>
    </td>
    </tr>
    
	<?php 
	//obsolete fragment of code: this is now done on line 123, dependent on getConfigSetting("SERVER_NOT_WRITABLE")
//    if ($exporttopage==True)
//    {
//		echo "<tr><td>";
//		echo "<textarea name=bibtex_data wrap=virtualcols=100 cols=80 rows=25>";
//		echo $feedback2; 
//		echo "</textarea>";
//		echo "</td></tr>";
//    
//		echo "<tr><td>";
//		echo "<textarea name=bibtex_data wrap=virtualcols=100 cols=80 rows=25>";
//		echo getbibtexpublicationtree(); 
//		echo "</textarea>";
//		echo "</td></tr>";
//    }
    ?>
    <input type=hidden name=action value=import>
    </table>
    </form>
    <?php 
    echo "".$feedback;
    //open resulting file in separate window
    if (getConfigSetting("SERVER_NOT_WRITABLE")!="TRUE") {
        echo "<script language='javascript'>window.open('".$FILEURL."export.bib','export_window','resizable', scrollbars,width=800, height=480,  left=0, top=0);</script>";
    }
} 
?>

<!-- Some support scripts for the settings page for generation of BiBTeX export... -->
<SCRIPT language="javascript">
    function toggleGUI(toggle, name) {
        if (toggle == true) {
            document.getElementById(name).className="expanded";
        } else {
            document.getElementById(name).className="collapsed";
        }
    }
</SCRIPT>

<!-- The settings page for generation of BiBTeX export... -->
<p class=header>Export publications</p>
<FORM name=exportsettingsform method="post">
    <TABLE>
    <tr><td colspan=2 class=header2 style="border-top:1px solid #E0E0E0;">
    General settings
    </td></tr>
        <tr><td>
      	  Export format
      	</td>
      	<td>
          <input type="radio" name="type" value="bibtex" checked>&nbsp;BibTeX&nbsp;&nbsp;<input type="radio" name="type" value="ris">&nbsp;RIS
      	</td></tr>
        <tr><td>
        Export first names as initials only
        </td>
        <td >
        	<INPUT TYPE=CHECKBOX <?php if ($initialsonly==True)echo "CHECKED"?> NAME='initialsonly' TITLE='Check to export only initials instead of full first names'>
        </td></tr>
        
    <!--tr><td colspan=2 class=header2 style="border-top:1px solid #E0E0E0;">
    Aigaion publication notes
    </td></tr>  

        <tr><td >
        <INPUT TYPE=CHECKBOX  <?php if ($exportnotes==True)echo "CHECKED"?> NAME='exportnotes' TITLE='Check to export publication notes in the database' 
            ONCLICK='toggleGUI(document.exportsettingsform.exportnotes.checked, "notesConfigGUI");'>
        </td>
        <td>
        Export aigaion publication notes
        </td></tr>
                
        <tr><td colspan=2 ><div <?php if ($exportnotes==True){echo "class=expanded";}else{echo "class=collapsed";}?> name=notesConfigGUI ID=notesConfigGUI >
        Some interface to select how to export notes...
        NOT IMPLEMENTED YET
        </div></td></tr>    

       
        
    <tr><td colspan=2 class=header2 style="border-top:1px solid #E0E0E0;">
    Aigaion topics
    </td></tr>  

        <tr><td >
        <INPUT TYPE=CHECKBOX  <?php if ($exporttopics==True)echo "CHECKED"?> NAME='exporttopics' TITLE='Check to export topics in the database' 
            ONCLICK='toggleGUI(document.exportsettingsform.exporttopics.checked, "topicsConfigGUI");'>
        </td>
        <td>
        Export aigaion topics
        </td></tr>
                
        <tr><td colspan=2 ><div <?php if ($exporttopics==True){echo "class=expanded";}else{echo "class=collapsed";}?> name=topicsConfigGUI ID=topicsConfigGUI >
        Some interface to select how to export topics...
        NOT IMPLEMENTED YET
        </div></td></tr-->    
            

<!--
    <tr><td colspan=2 class=header2 style="border-top:1px solid #E0E0E0;">
    Export bib-tex to page
    </td></tr>  
 DR: No need to keep this option, since we have the server write only setting, which embodies the only reason to do this... 
        <tr><td >
        <INPUT TYPE=CHECKBOX  <?php if ($exporttopage==True)echo "CHECKED"?> NAME='exporttopage' TITLE='Check to show bib-tex file in webrowser' 
            ONCLICK='toggleGUI(document.exportsettingsform.exporttopage.checked, "topicstopageConfigGUI");'>
        </td>
        <td>
        Show BIB-tex information in web page
        </td></tr>
                
        <tr><td colspan=2 ><div <?php if ($exporttopage==True){echo "class=expanded";}else{echo "class=collapsed";}?> name=topicstopageConfigGUI ID=topicstopageConfigGUI >
        
        </div></td></tr>    
-->
        
<!--
    <tr><td colspan=2 class=header2 style="border-top:1px solid #E0E0E0;">
    Export publication tree in TEX style
    </td></tr>  

        <tr><td >
        <INPUT TYPE=CHECKBOX  <?php if ($exporttopagepublicationtree==True)echo "CHECKED"?> NAME='exporttopagepublicationtree' TITLE='Check to show bib-tex file in webrowser' 
            ONCLICK='toggleGUI(document.exportsettingsform.exporttopagepublicationtree.checked, "topicstopageConfigGUI");'>
        </td>
        <td>
        Export publication tree in TEX style
        </td></tr>
                
        <tr><td colspan=2 ><div <?php if ($exporttopagepublicationtree==True){echo "class=expanded";}else{echo "class=collapsed";}?> name=topicstopagepublicationtreeConfigGUI ID=topicstopagepublicationtreeConfigGUI >
        -->

        
        </div></td></tr>    
        <tr><td colspan=2 style="border-top:1px solid #E0E0E0;">
        <br>&nbsp;
        <input type=hidden name=action value=generate>
        <input type=submit value="Generate" TITLE='Press to open window with exported BiBTeX data'>
        </td></tr>
        
    </TABLE>
</FORM>
        
