<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
Call this page with the following parameters:
    type=(attachment|note|person|topic)
    form=(add|change|delete|setrights)
    return  (used for return parameter in form, if possible)
    
plus whatever specific parameters are needed for the chosen form
(pub_id, note_id, etc)
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage 
include_once($DIR."lib/functions/topicfunctions.php");
        
/*
This page is ALWAYS called from a FORM, meaning that we can be sure that the parameters are affected by the magic_quote settings.

If you want to create a link to this page, make a form such as e.g. in displays/note.php#getLinkToNoteSetRightsPage

*/
#Register request and session vars
$form="";
if (isset($_REQUEST["form"])) {
    $form=$_REQUEST["form"];
}
$type="";
if (isset($_REQUEST["type"])) {
    $type=$_REQUEST["type"];
}
$note_id="";
if (isset($_REQUEST["note_id"])) {
    $note_id=$_REQUEST["note_id"];
}
$person_id="";
if (isset($_REQUEST["person_id"])) {
    $person_id=$_REQUEST["person_id"];
}
$pub_id="";
if (isset($_REQUEST["pub_id"])) {
    $pub_id=$_REQUEST["pub_id"];
}
$location="";
if (isset($_REQUEST["location"])) {
    $location=$_REQUEST["location"];
}
if (get_magic_quotes_gpc()==1) {
    $location = stripslashes($location);
}
$return="";
if (isset($_REQUEST["return"])) {
    $return=$_REQUEST["return"];
}
$topic_id="";
if (isset($_REQUEST["topic_id"])) {
    $topic_id=$_REQUEST["topic_id"];
}
$parent=getTopTopic();
if (isset($_REQUEST["parent"])) {
    $parent=$_REQUEST["parent"];
}

switch ($type) {
    case "attachment":
        include_once($DIR."lib/editforms/attachmenteditforms.php");
        switch ($form) {
            case "add":
                include_once($DIR."lib/displays/publicationdisplays.php");
                echo getAttAddForm($pub_id,$return);
                echo getAttAddRemoteForm($pub_id,$return);
                echo "<p class=header>Publication summary::</p>";
                echo getPublicationSummaryByID($pub_id, "plain");
                break;
            case "edit":
                echo getAttEditFormByID($pub_id, $location, $return);
                break;
            case "delete":
                echo getAttDeleteFormByID($pub_id, $location,$return);
                break;    
        }
        break;
    case "note":
        include_once($DIR."lib/displays/notedisplays.php"); 
        include_once($DIR."lib/editforms/noteeditforms.php"); 
        include_once($DIR."lib/displays/publicationdisplays.php");
        switch ($form) {
            case "add":
                echo getNoteAddForm($pub_id,$return);
                echo "<p class=header>Publication summary::</p>";
                echo getPublicationSummaryByID($pub_id, "plain");
                break;
            case "change":
                echo getNoteChangeFormByID($note_id,$return);
                echo "<p class=header>Publication summary::</p>";
                echo getPublicationSummaryByID($pub_id, "plain");
                break;
            case "delete":
                echo getNoteDeleteFormByID($note_id,$return);
                break;                
            case "setrights":
                echo getNoteSetRightsFormByID($note_id,$return);
                break;                
        }
        break;        
    case "person":
        include_once($DIR."lib/editforms/personeditforms.php");
        switch ($form) {
            case "add":
                echo getPersonAddForm($return);
                break;
            case "change":
                echo getPersonEditFormByID($person_id,$return);
                break;
            case "delete":
                echo getPersonDeleteFormByID($person_id,$return);
                break;                
        }
        break;     
    case "topic":
        include_once($DIR."lib/editforms/topiceditforms.php");
        include_once($DIR."lib/functions/topicfunctions.php");
        include_once($DIR."lib/displays/topicdisplays.php");
        switch ($form) {
            case "add":
                echo getTopicAddForm($parent, $return);
                break;
            case "change":
                echo getTopicChangeFormByID($topic_id,$return);
                echo "<p class=header>Old topic description:</p>";
                echo getTopicDescriptionDisplayByID($topic_id);
                break;
            case "delete":
                echo getTopicDeleteFormByID($topic_id,$return);
                echo "<p class=header>Old topic description:</p>";
                echo getTopicDescriptionDisplayByID($topic_id);
                break;                
        }
        break;
}


?>
