<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/displays/importdisplays.php");
include_once($DIR."lib/editforms/importeditforms.php");
include_once($DIR."lib/actions/importactions.php");
include_once($DIR."lib/functions/importfunctions.php");

#Register request and session vars
$action="";
if (isset($_REQUEST["action"])) {
  $action=$_REQUEST["action"];
}

$type="";
if (isset($_REQUEST["type"])) {
  $type=$_REQUEST["type"];
}

$bibtexData="";
if (isset($_REQUEST["bibtexData"])) {
  $bibtexData=$_REQUEST["bibtexData"];
}

checkRights("EDIT");
//import: parse the input and present a import review form.
if ($action=='import') {
  if (trim($bibtexData) != "")
  {
    if (get_magic_quotes_gpc()==1)
      $bibtexData=stripslashes($bibtexData);


    //DR: test checking for illegal bibtex special char expressions
    //preg_match("(t|f)", $bibtexData, $matches);
    //echo "test... ".$bibtexData."<br>";
    //print_r($matches);
    //end DR
  
    if ($type == "ris")
      $entries = risParse($bibtexData);
    else 
      $entries = bibParse($bibtexData);
  
    if (!is_array($entries))
    {
      echo "<div class='errormessage'>No valid publications found in your input. Please check the syntax.</div>\n";
    }
    else
    { 
      echo "<div class='errormessage'>Please review the entries below which were found in the BiBTeX input. Uncheck the box in front of an entry if you want to skip importing that particular entry.\n";
      echo "<p>When you are sure that the information below is correct, press 'commit' to add the entries to the database.</div>\n";
      
      echo getReviewForm($entries, $bibtexData, $type);
    }
  }
  else
  {
    echo "<div class='errormessage'>No data to import.</div>\n";
  }
}

//commit: the user reviewed the input. Parse input and update
//corrections. Then add to DB.
else if ($action == 'commit') {
  if (trim($bibtexData) != "")
  {
    if (get_magic_quotes_gpc()==1)
    $bibtexData=stripslashes($bibtexData);
    
    if ($type == "ris")
      $entries = risParse($bibtexData);
    else 
      $entries = bibParse($bibtexData);
      
    if (!is_array($entries))
    {
      echo "<div class='errormessage'>No valid publications found in your input. Please check the syntax.</div>\n";
    }
    else
    {
      $pub_id = bibImportEntries($entries);
      
      global $URL;
      returnTo($URL."index.php?page=publication&kind=list&type=newest&ID=".$pub_id);
    }
  }
  else
  {
    echo "<div class='errormessage'>No data to import.</div>\n";
  }

}
//no action specified: display blank import page
else {
  ?>
  <p class=header>Import publications</p>
  Paste the entries (BiBTeX or RIS) to import in the text area below, select the format and then press "Import".
  <br/><br/>
  <p class=small>Based on the bibparse packages of bibliophile</p>
  <table border=0>
  <tr>
  <td class=small>
  <form name=importform method='post'>
  <input type=submit value='Import'>&nbsp;&nbsp;&nbsp;<input type="radio" name="type" value="bibtex" checked>&nbsp;BibTeX&nbsp;&nbsp;<input type="radio" name="type" value="ris">&nbsp;RIS
  <textarea name=bibtexData wrap=virtualcols=100 cols=80 rows=25></textarea>
  <input type=hidden name=action value=import>
  </form>
  </td>
  </tr>
  </table>
  <?php 
}

