<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/functions/exportfunctions.php");
/*
Call this page with parameters:

type (single|list|topic)
ID (single pub_id)
pub_ids (list of pub_ids)
topic_id (single topic id)

*/
#Register request and session vars
$type="single";
if (isset($_REQUEST["type"])) {
    $type=$_REQUEST["type"];
}
$ID="";
if (isset($_REQUEST["ID"])) {
    $ID=$_REQUEST["ID"];
}
$pub_ids=array();
if (isset($_REQUEST["pub_ids"])) {
    $pub_ids=$_REQUEST["pub_ids"];
}
$topic_id="0";
if (isset($_REQUEST["topic_id"])) {
    $topic_id=$_REQUEST["topic_id"];
}
$format="bibtex";
if (isset($_REQUEST["format"])) {
		$format=strtolower($_REQUEST["format"]);
}
#Maybe allow bibtexID as input parameter, besides pub_id?

?>
<?php 

switch ($type) {
    case "single":
        $pub_id = $ID;
        
        exportBufferStart();
        if ($format == "ris")
        	exportRIS($pub_id);
        else 
        	exportBibtex($pub_id);
        exportBufferEnd();
        break;
    case "list":
        if ((sizeof($pub_ids)==0)||($pub_ids=="")) {
        		if ($format == "ris") $exportType = "RIS";
        		else $exportType = "BibTeX";
            echo "<div class=message>".$exportType." export: No publications were selected.</div>";
        } else {
            exportBufferStart();
            if ($format == "ris")
		        	exportRISList($pub_ids);
		        else 
		    			exportBibtexList($pub_ids);
            exportBufferEnd();
        }
        break;
    case "topic":
        exportBufferStart();
        if ($format == "ris")
        	exportRISForTopic($topic_id);
        else 
        	exportBibtexForTopic($topic_id);
        exportBufferEnd();
        break;
}
?>
