<?php 
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
 Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/* 
This is the entrypoint for all publication handling in aigaion.
For each kind, the required functions from the libraries are called.
  
  Supported kinds are:
  - single  for displaying a single publication
  - list    for displaying a list of publications
    - year
    - title
    - topic
    - author
    - journal
    - unassigned
    - newest
  - edit    for editting a publication from the database
  - new     for creating a new publication from scratch
  - delete  for deleting a publication from the database
  - confirm for confirming changes
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

#Register request and session vars
$kind="";
if (isset($_REQUEST["kind"])) {
  $kind=$_REQUEST["kind"];
}

$return="";
if (isset($_REQUEST["return"])) {
  $return=rawurldecode($_REQUEST["return"]);
}
?>
<?php 
error_reporting(E_ERROR);

switch ($kind) {
  case "single":
    include_once($DIR."lib/displays/publicationdisplays.php");
    $pub_id = "";
    if (isset($_REQUEST["ID"])) {
      $pub_id = $_REQUEST["ID"];
    }
    
    echo getPublicationByID($pub_id);
    
    break;
  
  case "list":
    include_once($DIR."lib/displays/publicationdisplays.php");
    $type = "";
    if (isset($_REQUEST["type"])) {
      $type = $_REQUEST["type"];
    }
  
    echo getPublicationList($type);
    break;
  
  case "edit":
    include_once($DIR."lib/editforms/publicationeditforms.php");
    $pub_id = "";
    if (isset($_REQUEST["ID"])) {
      $pub_id = $_REQUEST["ID"];
    }
    
    echo getPublicationForm($kind, $pub_id, $return);
    break;
    
  case "new":
    include_once($DIR."lib/editforms/publicationeditforms.php");
    echo getPublicationForm($kind);
    
    break;
    
  case "delete":
    include_once($DIR."lib/editforms/publicationeditforms.php");
    $pub_id = "";
    if (isset($_REQUEST["ID"])) {
      $pub_id = $_REQUEST["ID"];
    }
    
    echo getPublicationDeleteFormByID($pub_id,$return);
    echo "<p class=header>Publication summary:</p>";
    echo getPublicationSummaryByID($pub_id,"plain");
    break;
    
  case "confirm":
    include_once($DIR."lib/editforms/publicationeditforms.php");
    echo getPublicationConfirmForm($pub_id, $return);
    break;  
  
  default:
    break;
}
?>
