<?php
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
 Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."treefunctions.php");
include_once($DIR."lib/editforms/topiceditforms.php");
include_once($DIR."lib/functions/authorfunctions.php");
include_once($DIR."lib/displays/publicationdisplays.php"); //for displaying the found publications

#Register request and session vars
$command="";
if (isset($_REQUEST["command"])) {
  $command=$_REQUEST["command"];
}
$person_id="";
if (isset($_SESSION["personID"])) {
  $person_id=$_SESSION["personID"];
}
$showtype="";
if (isset($_REQUEST["type"])) {
  $showtype=$_REQUEST["type"];
}
$keywords="";
if (isset($_REQUEST["keywords"])) {
  $keywords = $_REQUEST["keywords"];
}
$optioncount=1;
if (isset($_REQUEST["count"])) {
  $optioncount=$_REQUEST["count"];
}
$count=0;
while ($count < $optioncount) {
  if (isset($_REQUEST["do".$count.""])) {
    $dodonot[$count]=$_REQUEST["do".$count.""];
  }
  if (isset($_REQUEST["topic".$count.""])) {
    $topicselect[$count]=$_REQUEST["topic".$count.""];
  }
  $count+=1;
}

//first, build the query
$doquery = "";
$donotquery = "";

if ($command == "search")
{
  $doquery = "(SELECT pub_id FROM publication)";
  $showtype = 2;
  $optioncount = 0;
  $command = "commit";
}
if ($command == "commit")
{
  //$showtype contains whether to show authors or publications.
  //0=publications 1=authors
  //$topicselect[] contains topic ID
  //$andor[] 0=and 1=or
  //$dodonot[] 0=do 1=dont
  //we want to return publications. Later on we can still find the belonging authors

  //build the do and the donot query
  for ($count = 0; $count < $optioncount; $count++) {

    //create subquery
    $subquery = "(SELECT DISTINCT pub_id FROM topicpublication WHERE topic_id = ".$topicselect[$count]." ";

    //check wether it is part of do or of donot query
    if ($dodonot[$count] == 0) {
      if ($doquery != "") {
        $doquery.= "AND pub_id IN ";
      }
      $doquery.=$subquery;
    }
    else {
      if ($donotquery != "") {
        $donotquery.= "OR pub_id IN ";
      }
      $donotquery.=$subquery;
    }
  }


  //stick the do and do-not query together
  $query = "SELECT DISTINCT pub_id FROM topicpublication WHERE pub_id ";

  if ($doquery != "") {
    $query.="IN ".$doquery;
  }
  if ($donotquery != "") {
    if ($doquery != "") {
      $query.="AND pub_id ";
    }
    $query.="NOT IN ".$donotquery;
  }

  for ($count = 0; $count < $optioncount; $count++) {
    $query.=")";
  }

  if ($showtype == 1){ //we want to return authors
    //$query = "SELECT * FROM author WHERE id IN (SELECT DISTINCT author FROM publicationauthor WHERE pub_id IN (".$query."))";
    //echo $query;
    $query = "SELECT DISTINCT author.* FROM author, publicationauthor WHERE author.id = publicationauthor.author and publicationauthor.pub_id IN (".$query.")";
  }
  if ($showtype != 2){ //we do not search for keywords

    $res = mysql_query($query);

    echo "<table class=vlist width=100%>";
    
    if (mysql_num_rows($res) == 0) {
      echo "<tr><td colspan=2>";
      echo "<p class=header>There are no ";
      if ($showtype == 0) {
        echo 'publications ';
      }
      else {
        echo 'authors ';
      }
      echo 'matching your search criteria.</p>';
      echo "</td></tr>\n";
    }
    else if ($showtype == 0) {
      echo "<TR><TD colspan=2><P class=header>Publications matching your criteria:</P></TD></TR>\n";
      $bResultsFound = false;
      while ($R = mysql_fetch_array($res))
      {
        echo getPublicationSummaryByID($R['pub_id'], "inTable", $_SESSION["summarystyle"], "true");
        $bResultsFound = true;
      }
    }
    else if ($showtype == 1) {
      echo "<TR><TD colspan=2><P class=header>Author matches</p></TD></TR>\n";
      while ($R = mysql_fetch_array($res))
      {
        echo "<TR>";
        echo "<TD colspan=2>";
        echo getLinkToAuthorPageFromRow($R);
        echo "</TD>";
        echo "</TR>\n";
      }
    }
    echo "</table>\n";
    if ($bResultsFound)
    {
      echo getAddCheckedToSelectedTopicForm();
      echo getExportSelectedToBiBTeXForm();
    }
  }//not for keyword search
  else { //we look for keywords
    //In this case we will show the nice tab-panel..
    
    
    $resultsfound=false;
    
    $resultarray = array();
    
    
    //TOPICS - subscribed
    
    //array of subscribed topics:
    $Qallsub = mysql_query("SELECT topic_id FROM persontopic WHERE persontopic.person_id=$person_id");
    while($R = mysql_fetch_array($Qallsub))
    {
      $Vallsub[] = $R['topic_id'];
    }
    
    $Qall = mysql_query("SELECT * FROM topic WHERE name LIKE '%$keywords%' ORDER BY name");
    
    echo mysql_error();
    if (mysql_numrows($Qall) > 0)
    {
      $header = "Topics (".mysql_numrows($Qall).")";
      $contents = "";
      while ($R = mysql_fetch_array($Qall))
      {
        $contents.= "<TR>";
        $contents.= "<TD colspan =2>";
        if (in_array($R['ID'],$Vallsub))
        {
          $contents.= '<A HREF="'.$URL.'?page=topic&topic_id='.$R['ID'].'">';
        }
        $contents.= preg_replace("/($keywords)/i", "<B>".$keywords."</B>",htmlspecialchars(urldecode($R['name'])));
        if (in_array($R['ID'],$Vallsub)) //uhmm.... if topic is in subscribed, just show it.
        {
          $contents.= '</A>';
        }
        else
        {
          //not subscribed: show a subscribe link which returns to same search result   
          //TODO: make this asynchronous       
          $contents.= getTopicSubscribeForm($R['ID'],$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"]);
        }
        $contents.= "</TD>";
        $contents.= "</TR>\n";
      }
      $resultsfound=true;
      $resultarray[$header] = $contents;
    }   
    
    //BIBTEX
    $Q = mysql_query("SELECT * FROM publication WHERE bibtex_id='$keywords'");
    echo mysql_error();
    if (mysql_numrows($Q) > 0)
    {
      $header = "Bibtex (".mysql_numrows($Q).")";
      $contents = "";
      while ($R = mysql_fetch_array($Q))
      {
        $contents.= getPublicationSummaryByID($R['pub_id'], "inTable", $_SESSION["summarystyle"], "true");       
        $contents.= "<TR>";
        $contents.= "<TD align=right valign=top class=small>Cite ID:</td><td>";
        $contents.= preg_replace("/($keywords)/i", "<B>".$keywords."</B>",htmlspecialchars(urldecode($R['bibtex_id'])));
        $contents.= '<br/><br/>';
        $contents.= "</TD>";
        $contents.= "</TR>\n";
      }
      $resultsfound=true;
      $resultarray[$header] = $contents;
    }
    
    //TITLE
    $Q = mysql_query("SELECT * FROM publication WHERE title LIKE '%$keywords%'");
    if (mysql_numrows($Q) > 0)
    {
      $header = "Titles (".mysql_numrows($Q).")";  
      $contents ="";    
      while ($R = mysql_fetch_array($Q))
      {
        $contents.= preg_replace('/((<[^<>]*?>)+?)([^<>]*)('.$keywords.')([^<>]*)/Usi',"\\1\\3<B>".$keywords."</B>\\5",getPublicationSummaryByID($R['pub_id'], "inTable", $_SESSION["summarystyle"], "true"));
      }
      $resultsfound=true;
      $resultarray[$header] = $contents;
    }
    //KEYWORDS
    $Q = mysql_query("SELECT * FROM publication WHERE keywords LIKE '%$keywords%'");
    if (mysql_numrows($Q) > 0)
    {
      $header = "Keywords (".mysql_numrows($Q).")";    
      $contents = "";  
      while ($R = mysql_fetch_array($Q))
      {
        $contents.=  getPublicationSummaryByID($R['pub_id'], "inTable", $_SESSION["summarystyle"], "true");
        $contents.=  "<TR>";
        $contents.=  "<TD align=right valign=top class=small>Keywords:</td><td>";
        $contents.=  Preg_replace("/($keywords)/i", "<B>".$keywords."</B>",$R['keywords']);
        $contents.=  "<br/><br/>";
        $contents.=  "</TD>";
        $contents.=  "</TR>\n";
      }
      $resultsfound=true;
      $resultarray[$header] = $contents;
    }

    //AUTHORS
    $Q = mysql_query("SELECT * FROM author WHERE surname LIKE '%$keywords%'");
    if (mysql_numrows($Q) > 0)
    {
      $header = "Authors (".mysql_numrows($Q).")"; 
      $contents = "";
      while ($R = mysql_fetch_array($Q))
      {
        $contents.= "<TR>";
        $contents.= "<TD colspan=2>";
        $contents.= getLinkToAuthorPageFromRow($R);
        $contents.= "</TD>";
        $contents.= "</TR>\n";
      }
      $resultsfound=true;
      $resultarray[$header] = $contents;
    }

    //NOTES..
    $sqlquery = "SELECT publication.pub_id as ID, publication.title as title, personpublicationnote.text AS text ";
    $sqlquery = $sqlquery."FROM publication, personpublicationnote ";
    $sqlquery = $sqlquery."WHERE personpublicationnote.pub_id = publication.pub_id AND personpublicationnote.text LIKE '%$keywords%' ";
    $sqlquery = $sqlquery."AND (personpublicationnote.rights = 'public' OR personpublicationnote.person_id = ".$person_id.")";
    $Q=mysql_query($sqlquery);
    if (mysql_numrows($Q) > 0)
    {
      $header = "Notes (".mysql_numrows($Q).")";    
      $contents = "";   
      while ($R = mysql_fetch_array($Q))
      {
        $contents.= preg_replace('/((<[^<>]*?>)+?)([^<>]*)('.$keywords.')([^<>]*)/Usi',"\\1\\3<B>".$keywords."</B>\\5",getPublicationSummaryByID($R['ID'], "inTable", $_SESSION["summarystyle"], "true"));
      }
      $resultsfound=true;
      $resultarray[$header] = $contents;
    }
    
    //ABSTRACTS
    $Q = mysql_query("SELECT * FROM publication WHERE abstract LIKE '%$keywords%'");
    if (mysql_numrows($Q) > 0)
    {
      $header = "Abstracts (".mysql_numrows($Q).")";    
      $contents = "";
      while ($R = mysql_fetch_array($Q))
      {
        $contents.= getPublicationSummaryByID($R['pub_id'], "inTable", $_SESSION["summarystyle"], "true");
        $contents.= "<TR>";
        $contents.= "<TD align=right valign=top class=small>Abstract:</td><td class=small>";
        $contents.=preg_replace("/($keywords)/i", "<B>".$keywords."</B>",$R['abstract']);
        $contents.= "<br/><br/>";
        $contents.= "</TD>";
        $contents.= "</TR>\n";
      }
      $resultsfound=true;
      $resultarray[$header] = $contents;
    }

  
  
  echo "<table class=vlist width=100%>\n";
  if ($resultsfound)
  {
    //create javascript to clear all options
    // yes I know this is a bit hacking, but we want to do a release don't we :)
    // a nice solution would be I think to number the kind of results.. (e.g. topics=0 etc.)
    echo "<script>";
    echo "function ClearOptions() {\n";
    foreach ($resultarray as $header => $contents)
    {
        echo "document.getElementById('h_".$header."').className='headermenu';\n";
        echo "document.getElementById('c_".$header."').className='collapsed';\n";
    }
    echo "}\n";
    echo "</script>";
    
    //create header:
    echo "<TR>";
    $firstheader = true; // select  the first one as default
    foreach ($resultarray as $header => $contents)
    {
        $width = 100 / sizeof($resultarray);
        echo "<TD id=\"h_".$header."\" width=".$width."% class=";        
        if ($firstheader)
        {
            echo "header";
        }
        else
        {
            echo "headermenu";
        }       
        echo " >";
        echo "<A HREF=\"#\" onclick=\"ClearOptions();document.getElementById('h_".$header."').className='header';document.getElementById('c_".$header."').className='expanded';return false;\">";
        echo $header;
        echo "</A>";
        echo "</TD>";
        $firstheader = false;
    }
    echo "</TR><TR>\n";
    //create contents
    echo "<TD colspan=".sizeof($resultarray).">";
    $firstheader = true; // select  the first one as default
    foreach ($resultarray as $header => $contents)
    {
        echo "<div id=\"c_".$header."\" class=";      
        if ($firstheader)
        {
            echo "expanded";
        }
        else
        {
            echo "collapsed";
        }
        echo ">";
        echo "<table width=100%>";

        
        echo $contents;
        echo "</table>";
        echo "</div>";
        
        
        $firstheader = false;
    }
    echo "</TD></TR>\n";
  
  }
  } // query for keywords
  
  
  if (!$resultsfound) {
      echo '<P class=header>No results found for your keywords</P>';
    }
  echo '</table>';
  if ($resultsfound)
  {
    echo getAddCheckedToSelectedTopicForm();
   	echo "<table><tr><td>Export selected publications to:</td><td>".getExportSelectedForm("BibTeX")."</td>";
    echo "<td>".getExportSelectedForm("RIS")."</td></tr></table>";
  }
} // command = commit
else
{
  ?>

  <table class=vlist cellspacing="0">
  <tr>
  <td align="right">
  <form name="mainform" action="">
  <?php
  $values=array("Publications", "Authors", "Keywords");

  $entryline = " ONCHANGE=\"";
  $entryline.="document.location='index.php?page=search&type=";
  $entryline.="'+document.mainform.showselect.options[document.mainform.showselect.selectedIndex].value+'";
  $entryline.="&count=".($optioncount)."";
  $count2=0;
  while ($count2 < $optioncount) {
    $entryline.="&do".$count2."='+document.mainform.dodonot".$count2.".options[document.mainform.dodonot".$count2.".selectedIndex].value+'";
    $entryline.="&topic".$count2."='+document.mainform.topicselect".$count2.".options[document.mainform.topicselect".$count2.".selectedIndex].value+'";
    $count2+=1;
  }
  $entryline.="'\";";

  echo "Find <select name=showselect ".$entryline." >";

  $count2=0;
  foreach ($values as $entrytype)
  {
    echo "<OPTION VALUE=\"".$count2."\"";
    if ($showtype == $count2)
    echo ' selected ';
    echo " > ".$entrytype. "</OPTION>\n";
    $count2+=1;
  }
  echo "</select>\n";


  $count = 0;
  while ($count < $optioncount){

    if ($count > 0) {
      echo 'and ';
    }

    //add .. that do/do not ...
    $values=array("do","do not");
    $name = "dodonot".$count;
    echo "that <select name=".$name.">";
    $count2=0;
    foreach ($values as $entrytype)
    {
      echo "<OPTION VALUE=\"".$count2."\"";
      if ($dodonot[$count] == $count2)
      echo ' selected ';
      echo " > ".$entrytype. "</OPTION>\n";
      $count2+=1;
    }
    echo "</select>";

    //query for topics, topic Topic IDs
    //build box
    $name="topicselect".$count;
    $res=mysql_query("SELECT ID, name FROM topic ORDER BY name;");
    if($res)
    {
      echo " appear in topic ";
      echo "<select name=".$name." size=1>";
      $query= "SELECT ID FROM topic,persontopic WHERE persontopic.topic_id=ID AND persontopic.person_id=".$_SESSION["personID"]." ORDER BY topic.name";
      $res2=mysql_query($query);
      while($row2 = mysql_fetch_array($res2)) {
	      $totaltopictree[] = $row2["ID"];
      }
  	  echo getTopicOptionTree(makeTopicTree($totaltopictree),$topicselect[$count]);
      echo "</select><br/>";
    }
    $count+=1;
  }


  //add searchform for keywords
  if ($showtype == 2) {
    echo '<br/></td></tr>';
    echo '<tr><td align="left">';
    echo 'Keyword: <input name="keywords" type="text" size="30" value="'.$keywords.'" onKeyPress="return submitOnEnter(event)">';
  }
  echo '<br/><br/></td></tr>';
  echo '<tr><td>';
  ?>
  </form>

  <table width = 100%>
  <tr>
  <td align="right">
  <form name="addform" onSubmit="return AddCondition();" action="" method="post">
  <input type=submit value="Add Condition">
  </form>
  </td>
  <td align="left">
  <form name="submitform" onSubmit="return Search();" action="" method="post">
  <input type=submit value="Search">
  </form>
  </td>
  </tr>
  </table>

  </td>
  </tr>
  </table>
  <?php

}
?>

<script SCRIPT LANGUAGE="JavaScript">
function AddCondition()
{
  <?php
  $entryline="document.addform.action='index.php?page=search&type=";
  $entryline.="'+document.mainform.showselect.options[document.mainform.showselect.selectedIndex].value+'";
  $entryline.="&count=".($optioncount+1)."";
  if ($showtype == 2) {
    $entryline.="&keywords='+document.mainform.keywords.value+'";
  }
  $count2=0;
  while ($count2 < $optioncount) {
    $entryline.="&do".$count2."='+document.mainform.dodonot".$count2.".options[document.mainform.dodonot".$count2.".selectedIndex].value+'";
    $entryline.="&topic".$count2."='+document.mainform.topicselect".$count2.".options[document.mainform.topicselect".$count2.".selectedIndex].value+'";
    //    if ($count2 > 0) {
    //      $entryline.="&and".$count2."='+document.mainform.andor".$count2.".options[document.mainform.andor".$count2.".selectedIndex].value+'";
    //    }

    $count2+=1;
  }
  $entryline.="';";
  echo $entryline."\n";
  ?>
}

function Search()
{
  <?php
  $entryline="document.submitform.action='index.php?page=search&command=commit&type=";
  $entryline.="'+document.mainform.showselect.options[document.mainform.showselect.selectedIndex].value+'";
  $entryline.="&count=".($optioncount)."";
  if ($showtype == 2) {
    $entryline.="&keywords='+document.mainform.keywords.value+'";
  }
  $count2=0;
  while ($count2 < $optioncount) {
    $entryline.="&do".$count2."='+document.mainform.dodonot".$count2.".options[document.mainform.dodonot".$count2.".selectedIndex].value+'";
    $entryline.="&topic".$count2."='+document.mainform.topicselect".$count2.".options[document.mainform.topicselect".$count2.".selectedIndex].value+'";
    //    if ($count2 > 0) {
    //      $entryline.="&and".$count2."='+document.mainform.andor".$count2.".options[document.mainform.andor".$count2.".selectedIndex].value+'";
    //    }

    $count2+=1;
  }
  $entryline.="';";
  echo $entryline."\n";
  ?>
}

function submitOnEnter(e)
{
  var keycode;
  if (window.event) 
    keycode = window.event.keyCode;
  else if (e) 
    keycode = e.which;
  else 
    return true;
  
  if (keycode == 13)
  {
    document.submitform.submit(Search());
    return false;
  }
  else
    return true;
}
</script>
