<?php
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
 Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once($DIR."includes/file_upload/upload_class.php"); 

if (isset($_REQUEST["dbadmin"])) {
    $dbadmin=$_REQUEST["dbadmin"];
}
if (isset($_REQUEST["dbadminpwd"])) {
    $dbadminpwd=$_REQUEST["dbadminpwd"];
}
//The method that is called externally. See _DATABASEVERSIONMANAGEMENT.txt 
//for what to do if you introduce a new version.
//Pre: the database is connected.
//In this first function you should adapt the latest version to check..
function checkDatabase() {       
    if (!(adminLogin()))
        return false;
        
    //delegate check to checkschemafile for latest release...
    global $DIR;
    include($DIR."schema/checkschema_v1.php");
    
    //check whether this is the first time install, if so: be silent!
    $bSilent = false;
    $R = mysql_query("SELECT version FROM aigaiongeneral");
    if (!$R) {
        $bSilent = true;
    }
    	
    if ($bSilent)
    {
    	echo "<div class=message>";
	    echo ("Welcome to Aigaion, we are setting up the database structure for first use.<br/>");
	    echo "</div>";
    }
    if (!(checkDatabaseV1_3($bSilent)))
        return false;    
    
    if ($bSilent)
    {
    	echo "<div class=message>";
	    echo ("Succeeded creating database structure.<br/>");
	    echo "</div>";
    }
    
        
    $_SESSION["config"] = array(); //clear config settings cache, because settings may have been changed by the schema update
    if (!(adminLogout()))
        return false;
    return true;    
    }

//================================================================
//  INTERNAL HELPER METHODS
//================================================================

//returns true if version number exists and is correct
//also display debug information
function checkVersion($v, $bSilent=false) {
    $res = mysql_query("SELECT version FROM aigaiongeneral");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row["version"]==$v) { //if version == latest version number, return true
            return true;
        } 
    }
    if (!$bSilent)
    {
	    echo "<div class=message>";
	    echo ("Checking version ".$v."... update needed.<br>");
	    echo "</div>";
  	}
    return false;
}

//set the version of the database to the given version; show some debug information.
function setVersion($v, $bSilent=false) {
    
    $res = mysql_query("UPDATE aigaiongeneral SET version='$v'");
    if (!$res) { 
        dbError(mysql_error());        
        return false;
    }    
    if (!$bSilent)
    {
	    echo "<div class=message>";
	    echo ("Update version ".$v." Succeeded<br>"); //for debug
	    echo "</div>";
	  }
    return true;
}

//set the version of the release to the given version; show some debug information.
function setReleaseVersion($v, $bSilent=false) {
    
    $res = mysql_query("UPDATE aigaiongeneral SET releaseversion='$v'");
    if (!$res) { 
        dbError(mysql_error());        
        return false;
    }    
    if (!$bSilent)
    {
	    echo "<div class=message>";
	    echo ("Update to release version ".$v." Succeeded<br>"); //for debug
	    echo "</div>";
	  }
    return true;
}

//error function
function dbError($mysqlerror)
{
        echo "<div class=message>";
        echo "<br>".$mysqlerror."<br>UPDATE NOT SUCCESSFULL<br>";
        echo "Note that you can set a special db user with parameters: ?dbadmin=...&dbadminpwd=...";
        echo "</div>";
}



function adminLogin()
{
    global $dbadmin;
    global $dbadminpwd;
    global $mysql_host;
    global $mysql_user;
    global $mysql_pass;        
    if (isset($dbadmin))
    {
    echo "<div class=message>";
    echo "Special db user logged in";
    
    echo "</div>";
    if (mysql_connect($mysql_host,$dbadmin,$dbadminpwd)) {
        if (!mysql_select_db($_SESSION['database'])) {
            echo "no good db";
            return false;            
        }
    }
    else
    {
        echo "db connection failed";
        return false;
    }
    }
    return true;    
}

function adminLogout()
{
    global $dbadmin;
    global $dbadminpwd;
    global $mysql_host;
    global $mysql_user;
    global $mysql_pass;          
    if (isset($dbadmin))
    {    
    if (mysql_connect($mysql_host,$mysql_user,$mysql_pass)) {
        if (!mysql_select_db($_SESSION['database'])) {
            echo "no good db";
            return false;
        }
        echo "<div class=message>";
        echo "Special db user logged out";    
        echo "</div>";
    }
    else
    {
        echo "db connection failed";
        return false;
    }    
    }
    return true;
}
?>
