<?php
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
 Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


/*
Version 1.3 changes the notefield to "text" and introduces a release version field.
*/
function checkDatabaseV1_3($bSilent = false) {
  if (checkVersion("V1.3",$bSilent)) return true;
  if (!checkDatabaseV1_2($bSilent)) return false;
  
  if (!$bSilent)
  	echo ("Updating version V1.3... "); //for debug
  
  $res = mysql_query("ALTER TABLE `publication` CHANGE `note` `note` TEXT NOT NULL");

  if (!$res) {
    dbError(mysql_error());
    return false;
  }
  
 	$res = mysql_query("ALTER TABLE `aigaiongeneral` ADD `releaseversion` VARCHAR( 10 ) NOT NULL");
 	
  if (!$res) {
    dbError(mysql_error());
    return false;
  }
  
  if (!setVersion("V1.3", $bSilent))  return false;    
  
  setReleaseVersion("1.1");
    
  return true;   
  
}

/*
Version 1.2 introduces the latin character conversion and multipage publication lists
*/
function checkDatabaseV1_2($bSilent = false) {
  if (checkVersion("V1.2",$bSilent)) return true;
  if (!checkDatabaseV1_1($bSilent)) return false;
  
  if (!$bSilent)
  	echo ("Updating version V1.2... "); //for debug
  
  $res = mysql_query("ALTER TABLE `person` ADD `liststyle` SMALLINT NOT NULL DEFAULT '0' AFTER `summarystyle`");

  if (!$res) {
    dbError(mysql_error());
    return false;
  }
  
 	$_SESSION['liststyle'] = '0';
  
  if (!setVersion("V1.2", $bSilent))  return false;
  
  return true;   
  
}
/*
Version 1.1 introduces the new table for site-config-settings, and fills it with default values, possibly taken from the config file.
*/
function checkDatabaseV1_1($bSilent = false) {
  if (checkVersion("V1.1",$bSilent)) return true;
  if (!checkDatabaseV1_0($bSilent)) return false;
  if (!$bSilent)
  	echo ("Updating version V1.1... "); //for debug
  
  #create new table for config settings. Columns: 'setting' / 'value' ; primkey 'setting'
  $res = mysql_query("CREATE TABLE `config` (`setting` varchar(255) NOT NULL, `value` varchar(255) NOT NULL, PRIMARY KEY  (`setting`)) TYPE=MyISAM;");
  if (!$res) {
      dbError(mysql_error());        
      return false;
  }
      
  #fill table with settings from config file: getConfigSetting("CFG_ADMIN"), getConfigSetting("CFG_ADMINMAIL"), $DIR, $URL, $FILEDIR, $ALLOWED_ATTACHMENT_EXTENSIONS, $ALLOW_ALL_EXTERNAL_ATTACHMENTS, $server_not_writable, $WINDOW_TITLE, $ALWAYS_INCLUDE_PAPERS_FOR_TOPIC, $SHOW_TOPICS_ON_FRONTPAGE=True $SHOW_TOPICS_ON_FRONTPAGE_LIMIT=5;
  global $CFG_ADMIN, $CFG_ADMINMAIL, $DIR, $URL, $FILEDIR, $ALLOWED_ATTACHMENT_EXTENSIONS, $ALLOW_ALL_EXTERNAL_ATTACHMENTS, $WINDOW_TITLE, $ALWAYS_INCLUDE_PAPERS_FOR_TOPIC, $SHOW_TOPICS_ON_FRONTPAGE, $SHOW_TOPICS_ON_FRONTPAGE_LIMIT;
  if (!isset($CFG_ADMIN)) {
    $CFG_ADMIN = "Administrator";
  }
  if (!isset($CFG_ADMINMAIL)) {
    $CFG_ADMINMAIL = "Administrator@some.where";
  }
  if (!isset($ALLOWED_ATTACHMENT_EXTENSIONS)) {
    $ALLOWED_ATTACHMENT_EXTENSIONS_STR = ".doc,.gif,.htm,.html,.jpeg,.jpg,.pdf,.png,.tif,.tiff,.txt,.zip";
  } else {
    $ALLOWED_ATTACHMENT_EXTENSIONS_STR = implode(",", $ALLOWED_ATTACHMENT_EXTENSIONS);
  }
  if (isset($ALLOW_ALL_EXTERNAL_ATTACHMENTS) && ($ALLOW_ALL_EXTERNAL_ATTACHMENTS)) {
    $ALLOW_ALL_EXTERNAL_ATTACHMENTS = "TRUE";
  } else {
    $ALLOW_ALL_EXTERNAL_ATTACHMENTS = "FALSE";
  }
  if (!isset($WINDOW_TITLE)) {
    $WINDOW_TITLE = "Aigaion: A multi user annotated bibliography";
  }
  if (isset($ALWAYS_INCLUDE_PAPERS_FOR_TOPIC) && $ALWAYS_INCLUDE_PAPERS_FOR_TOPIC) {
    $ALWAYS_INCLUDE_PAPERS_FOR_TOPIC = "TRUE";
  } else {
    $ALWAYS_INCLUDE_PAPERS_FOR_TOPIC = "FALSE";
  }
  
  if (isset($SHOW_TOPICS_ON_FRONTPAGE) && $SHOW_TOPICS_ON_FRONTPAGE) {
    $SHOW_TOPICS_ON_FRONTPAGE = "TRUE";
  } else {
    $SHOW_TOPICS_ON_FRONTPAGE = "FALSE";
  }
  if (!isset($SHOW_TOPICS_ON_FRONTPAGE_LIMIT)) {
    $SHOW_TOPICS_ON_FRONTPAGE_LIMIT = 5;
  } 
  if (isset($SERVER_NOT_WRITABLE) && $SERVER_NOT_WRITABLE) {
    $SERVER_NOT_WRITABLE = "TRUE";
  } else {
    $SERVER_NOT_WRITABLE = "FALSE";
  }

  $query = "INSERT INTO config (`setting`,`value`) VALUES ";
  $query .= "('CFG_ADMIN','".addslashes($CFG_ADMIN)."'),";
  $query .= "('CFG_ADMINMAIL','".addslashes($CFG_ADMINMAIL)."'),";
  $query .= "('ALLOWED_ATTACHMENT_EXTENSIONS','".addslashes($ALLOWED_ATTACHMENT_EXTENSIONS_STR)."'),";
  $query .= "('ALLOW_ALL_EXTERNAL_ATTACHMENTS','".addslashes($ALLOW_ALL_EXTERNAL_ATTACHMENTS)."'),";
  $query .= "('WINDOW_TITLE','".addslashes($WINDOW_TITLE)."'),";
  $query .= "('ALWAYS_INCLUDE_PAPERS_FOR_TOPIC','".addslashes($ALWAYS_INCLUDE_PAPERS_FOR_TOPIC)."'),";
  $query .= "('SHOW_TOPICS_ON_FRONTPAGE','".addslashes($SHOW_TOPICS_ON_FRONTPAGE)."'),";
  $query .= "('SHOW_TOPICS_ON_FRONTPAGE_LIMIT','".addslashes($SHOW_TOPICS_ON_FRONTPAGE_LIMIT)."'),";
  $query .= "('SERVER_NOT_WRITABLE','".addslashes($SERVER_NOT_WRITABLE)."');";
 
  $res = mysql_query($query);
  if (!$res) {
      dbError(mysql_error());        
      return false;
  }  
  
  if (!setVersion("V1.1",$bSilent))  return false;    
  return true;   
}

/*
Version 1.0 checks whether the updates for the previous major release (V0.xx) was performed
*/
function checkDatabaseV1_0($bSilent = false) {
  if (checkVersion("V1.0",$bSilent)) return true;
  global $DIR;
  include($DIR."schema/checkschema_v0.php");
  if (!checkDatabaseV0_14($bSilent)) return false;
  if (!$bSilent)
  	echo ("Updating version V1.0... "); //for debug
  if (!setVersion("V1.0",$bSilent))  return false;    
  return true;   
}
?>