<?php
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
This page is the access to the installation actions, where the information from the
install-settings-form will be submitted. Here we check the content from the form for 
inconsistencies and incompleteness. If the check fails, the user redirected back to 
the (filled) form with appropriate feedback. If the check succeeds, the actions needed
to install the Aigaion system are executed and the user is notified of the results.

This page is called from the form in installeditforms.php, which is displayed in install.php.
This page used installactions to actually do the work of installing the Aigaion site.
*/

include_once ("installactions.php");
include_once ("installfunctions.php");

$webserver_name = "";
if (isset($_REQUEST["webserver_name"])) {
    $webserver_name = $_REQUEST["webserver_name"];
}
$webserver_port = "";
if (isset($_REQUEST["webserver_port"])) {
    $webserver_port = $_REQUEST["webserver_port"];
}
$install_dir = "";
if (isset($_REQUEST["install_dir"])) {
    $install_dir = $_REQUEST["install_dir"];    
}
$urlpath = "";
if (isset($_REQUEST["urlpath"])) {
    $urlpath = $_REQUEST["urlpath"];    
}
$attachmentpath = "";
if (isset($_REQUEST["attachmentpath"])) {
    $attachmentpath = $_REQUEST["attachmentpath"];    
}
$mysql_host = "";
if (isset($_REQUEST["mysql_host"])) {
    $mysql_host = $_REQUEST["mysql_host"];
}
$mysql_database = "";
if (isset($_REQUEST["mysql_database"])) {
    $mysql_database = $_REQUEST["mysql_database"];
}
$create_schema = FALSE;
if (isset($_REQUEST["create_schema"])) {
    $create_schema = TRUE;
}
$create_user = FALSE;
if (isset($_REQUEST["create_user"])) {
    $create_user = TRUE;
}
$create_tables = FALSE;
if (isset($_REQUEST["create_tables"])) {
    $create_tables = TRUE;
}
$rootuser = "";
if (isset($_REQUEST["rootuser"])) {
    $rootuser = $_REQUEST["rootuser"];
}
$rootpwd = "";
if (isset($_REQUEST["rootpwd"])) {
    $rootpwd = $_REQUEST["rootpwd"];
}
$aigaionuser = "";
if (isset($_REQUEST["aigaionuser"])) {
    $aigaionuser = $_REQUEST["aigaionuser"];
}
$aigaionpwd = "";
if (isset($_REQUEST["aigaionpwd"])) {
    $aigaionpwd = $_REQUEST["aigaionpwd"];
}
$aigaionpwd2 = "";
if (isset($_REQUEST["aigaionpwd2"])) {
    $aigaionpwd2 = $_REQUEST["aigaionpwd2"];
}


#check if you are supposed to go here at all...
if (siteIsConfigured()) {
    failInstallCheck( "The site seems to have been configured already. A config.php exists. Please contact the site administrator.");
}

#CHECK FORM CONTENTS ON CONSISTENCY AND CORRECTNESS
$errorInSettings = FALSE;
$report = "";
#webserver_name, mysql_database, mysql_host, aigaionuser all cannot be empty
if ($webserver_name=="") {
    $errorInSettings=TRUE;
    $report .= "<li>The webserver name cannot be empty.";
}
if ($mysql_host=="") {
    $errorInSettings=TRUE;
    $report .= "<li>The mysql host name cannot be empty.";
}
if ($mysql_database=="") {
    $errorInSettings=TRUE;
    $report .= "<li>The mysql database name cannot be empty.";
}
if ($aigaionuser=="") {
    $errorInSettings=TRUE;
    $report .= "<li>The mysql user name name cannot be empty.";
}

#is webserver_port a number or empty?
if (!is_numeric($webserver_port)&& ($webserver_port!="")) {
    $errorInSettings=TRUE;
    $report .= "<li>The server port value should be empty or a number.";
}
    
#if user should be created, is aigaion password types twice, and twice the same?
if ($create_user && ($aigaionpwd != $aigaionpwd2)) {
    $errorInSettings=TRUE;
    $report .= "<li>When creating a new database user, the password must have the same value twice.";
}

#if user or schema should be created, is rootuser filled out?
if (($create_user || $create_schema) && ($rootuser=="")) {
    $errorInSettings=TRUE;
    $report .= "<li>When creating a new database or database user, the root user and password must be specified.";
}


#other checks can be added as we think of them
#paths cannot contain . or ..
#paths should or should not begin or end with / depending on which path it is?
#remove special chars from site_title

    #check write rights on appropriate places?
    //test: is the current directory writable, so we can build a config.php file? I do not really like that. Is there another solution?
    //if (!is_writable($install_dir)) {
        //failInstall("The main directory should be writable in order to create a configuration file (config.php).";
    //}
    //etcetera


#AUTOMATIC SETTING FIXES
#if the path-part of the url (urlpath) is not pre- and suffixed with a slash, add it.
#if the install_dir is not pre- and suffixed with a slash, add it.

#IF AN ERROR OCCURRED, REPORT AND FAIL
if ($errorInSettings) {
    $report = "There are errors in the installation settings:<ul>$report</ul>Please correct the above errors. Note that you should now also retype the passwords!";
    failInstallCheck($report);
}

#DO INSTALL ACTION
//show results page for install action...
doInstall($webserver_name, $webserver_port, $install_dir, $urlpath, $attachmentpath, $mysql_host, $mysql_database, $create_schema, $create_user, $create_tables, $rootuser, $rootpwd, $aigaionuser, $aigaionpwd);

/*
Fail to install, return to install forms while giving feedback about the errors in it.
*/
function failInstallCheck($report) {
    global $webserver_name, $webserver_port, $urlpath, $attachmentpath, $mysql_host, $mysql_database, $create_schema, $create_user, $create_tables, $rootuser, $rootpwd, $aigaionuser, $aigaionpwd;
    echo "<script>document.location='install.php?webserver_name=$webserver_name&webserver_port=$webserver_port&install_dir=$install_dir&urlpath=$urlpath&attachmentpath=$attachmentpath&mysql_host=$mysql_host&mysql_database=$mysql_database&aigaionuser=$aigaionuser&create_schema=$create_schema&create_user=$create_user&create_tables=$create_tables&error=$report';</script>";
    die();
}
?>