<?php
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#EXECUTE INITIALIZATION OF DATABASE
//this function will dump its feedback directly to the outbut buffer as a full web page! i.e. including <html> etc tags
function doInstall($webserver_name, $webserver_port, $install_dir, $urlpath, $attachmentpath, $mysql_host, $mysql_database, $create_schema, $create_user, $create_tables, $rootuser, $rootpwd, $aigaionuser, $aigaionpwd) {
    #comment this out if you want to activate the install script
    //failInstall("I am so sorry... the request was not completed because the actual installation procedures have not yet been hooked up with this form. The reason for that is that I am not sure if the code is right. If you want to use this script you should find this message in the code, and figure out how to activate the install script...");
    
    #check existence of config script. If config.php already exists, kill this install script immediately and die.
    if (siteIsConfigured()) {
        kill_install_script();
        failInstall("A config.php file was encountered. You cannot use this install script because the aigaion installation seems to have already been configured.");
    }
        
    #create user and schema?
    if (($create_schema) || ($create_user)) {
        #connect to sql server as root if needed
        if (!mysql_connect($mysql_host,$rootuser,$rootpwd)) {
            failInstall("Could not connect to mysql server with root privileges");
        }
        //echo 
        
        #create table if right password and table should be created
        if ($create_schema) {
            mysql_query("CREATE DATABASE ".addslashes($mysql_database));
            if (mysql_error()) {
                failInstall("Could not create database with name ".$mysql_database.". Mysql error: ".mysql_error());
            }
        }
        
        #create user
        if ($create_user) {
            $query = "CREATE USER ".addslashes($aigaionuser)." IDENTIFIED BY '".addslashes($aigaionpwd)."'";
            mysql_query($query);
            if (mysql_error()) {
                failInstall("Could not create user with name ".$aigaionuser.". Mysql error: ".mysql_error());
            }
            
            #set user rights
            mysql_query("GRANT ALL ON ".addslashes($mysql_database).".* to ".addslashes($aigaionuser));
            if (mysql_error()) {
                failInstall("Could not give appropriate rights to user with name ".$aigaionuser.". Mysql error: ".mysql_error());
            }
            //GRANT ACCESS FROM LOCALHOST!
        }
    }
    
    #connect to database as user
    if (!mysql_connect($mysql_host,$aigaionuser,$aigaionpwd)) {
        failInstall("Could not access mysql server as aigaion user with name ".$aigaionuser.". Mysql error: ".mysql_error());
    }
    if (!mysql_select_db($mysql_database)) {
        failInstall("Could not select aigaion database ".$mysql_database.". Mysql error: ".mysql_error());
    }
    
    #fill table from schema.php
    if ($create_tables) {
        if (!parse_mysql_dump("../schema/aigaion.sql")) {
            failInstall("Could not initialize contents of aigaion database. Mysql error: ".mysql_error());
        }
    }
    
    #fix some settings automatically, such as ensuring trailing '/' for paths and urls
    if ((substr(trim($urlpath), -1, 1) != '/')) {
        $urlpath = trim($urlpath)."/";
    }
    $urlpath = str_replace("\\", "\\\\", $urlpath);
    if ((substr(trim($install_dir), -1, 1) != '/')) {
        $install_dir = trim($install_dir)."/";
    }
    $install_dir = str_replace("\\", "\\\\", $install_dir);
    if ((substr(trim($attachmentpath), -1, 1) != '/')) {
        $attachmentpath = trim($attachmentpath)."/";
    }
    $attachmentpath = str_replace("\\", "\\\\", $attachmentpath);
    if ((substr(trim($install_dir), -1, 1) != '/')) {
        $install_dir = trim($install_dir)."/";
    }
    $install_dir = str_replace("\\", "\\\\", $install_dir);
    
    #try to make 'documents' directory (or whatever was specified)
    if (!file_exists($install_dir.$attachmentpath))
        mkdir($install_dir.$attachmentpath);
    
    #build new config.php
    
    $fp = fopen($install_dir.'config.php', 'w');
    
    $result = "";
    $result .= "<?php\n";
    $result .= "/*\nWeb based document management system\nCopyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema\n\nThis program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program; if not, write to the Free Software\nFoundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n*/\n";
    $result .= "require_once(\"checkBase.php\"); //if this script is not called from within one of the base pages, redirect to frontpage\n";
    $result .= "# Host where database runs\n";
    $result .= "\$mysql_host=\"$mysql_host";
    $result .= "\";\n";
    $result .= "# Database user\n";
    $result .= "\$mysql_user=\"$aigaionuser\";\n";
    $result .= "# Database password\n";
    $result .= "\$mysql_pass=\"$aigaionpwd\";\n";
    $result .= "# Directory where Aigaion is located (\\ for dos, / for Linux)\n";
    $result .= "\$DIR = \"$install_dir\";\n";
    $result .= "# Address of this directory in browser\n";
    $result .= "\$URL = \"http://".$webserver_name;
    if ($webserver_port != 80) {
        $result .= ":$webserver_port";
    }
    $result .= "/$urlpath\";\n";
    $result .= "# Name of the standard database\n";
    $result .= "\$mysql_db=\"$mysql_database\";\n";
    $result .= "\$mysql_alldb = array();\n";
    $result .= "# You can add extra databases here by adding an extra\n";
    $result .= "# \$mysql_alldb[] = \"otherdatabase\"\n";
    $result .= "\$mysql_alldb[] = \$mysql_db;\n";

    $result .= "# Location of documents-directory via file-path\n";
    $result .= "\$FILEDIR = \$DIR.\"$attachmentpath\";\n";
    $result .= "# Location of documents-directory via browser\n";
    $result .= "\$FILEURL = \$URL.\"$attachmentpath\";\n";
    
        
    $success = fwrite($fp,$result);
    if ($success===FALSE) {
        echo "Install failed because the config.php could not be saved on the server. Please copy the text below and save it as config.php! After that, find a way to save that file on the server.";
        echo "\n<textarea virtualcols=100 cols=80 rows=25>\n";
        echo $result;
        echo "\n</textarea>";
    }

    
    #kill script
    kill_install_script();
    
    echo '<script>document.location=".http://$webserver_name:$webserver_port/$urlpath/index.php?message=The site was installed succesfully. Please log in the first time with username admin and password admin and proceed to configure the site and the user accounts";</script>';    

}
?>
<?php
/*
returns false, if any error
*/
  function parse_mysql_dump($url, $ignoreerrors = false) {
   $file_content = file($url);
   //print_r($file_content);
   $query = "";
   foreach($file_content as $sql_line) {
     $tsl = trim($sql_line);
     if (($sql_line != "") && (substr($tsl, 0, 2) != "--") && (substr($tsl, 0, 1) != "#")) {
       $query .= $sql_line;
       if(preg_match("/;\s*$/", $sql_line)) {
         $result = mysql_query($query);
         if (!$result && !$ignoreerrors) return FALSE;
         $query = "";
       }
     }
   }
   return TRUE;
  }
  
  function failInstall($message) {
    echo "<html><body>";
    echo "Could not finish installing database.<br>Error:<br>";
    echo $message;
    echo "</body></html>";
    die();
  }
    
  function kill_install_script() {
    //somehow deactivate this script for safety? remove? rename?
  }    
?>