<?php
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
This file contains the forms and subforms that the user needs to fill out in order to install the 
aigaion database. The form is (of course...) accessed by calling 'getInstallForm'. This install form 
is NOT dependent on config and settings, since the database does not yet exists when the form is used :-)

  MAIN FORM
    
    getInstallForm()
        returns the full form.
  
  SUB FORMS
  
    getDatabaseAndUserSubform
        This subform determines the name/server of the mysql database, and the user/pwd that will be 
        used by the new installation of aigaion.
        The subform is also responsible for determining whether the database and/or database user 
        still need to be created, and if so, for getting the root password to the mysql-server needed
        to create them.
        
        resulting parameters: $mysql_host, $mysql_database, $create_schema, $create_user, $create_tables
                              $rootuser, $rootpwd, $aigaionuser, $aigaionpwd

    getWebServerSubform
        This subform determines information about the webserver, inasfar as it cannot be determined 
        automatically. (?)
        
        resulting parameters: $install_dir, $webserver_name, $webserver_port, $urlpath, $attachmentpath
        
    
*/
    
function getInstallForm() {
    include_once ("installfunctions.php");
    if (siteIsConfigured()) {
        return "<div class=errormessage>The site seems to have been configured already. A config.php exists. If you want to change the settings of the site, use the 'site configuration' menu option. If you persist in trying to install using this form, you do run a risk of overwriting the contents of the existing aigaion database :-)</div>";
    }
    $form  = "";
    $form .="\n<DIV class=editform>";
    $form .="<p class=header>AIGAION INSTALLATION FORM</p>";
    $form .="<p>This site is not yet configured. To install Aigaion, you must complete the form.";
    $form .="<p>It may be possible that you also have to ask the administrator of the server on which this ";
    $form .="installation is running to provide you with information about your access to a mysql server. ";
    $form .="More information on this can be found in the appropriate sections of the form. ";
    $form .="<p>Note: this form only works if you have write access to the web server, because the script should save some configuration settings to file! ";
    $form .="\n<FORM name='installform' enctype='multipart/form-data' method='post' action='setup/do_install.php'>";
    
    $form .="\n<TABLE width=100%>";
    $form .= getWebServerSubform();
    $form .= getDatabaseAndUserSubform();
    $form .="\n<TR><TD colspan=2>";
    $form .="<hr>";
    $form .="<input type=submit value=Install>";
    
    $form .="</TD></TR>";

    $form .="\n</TABLE>";
    
    $form .="\n</FORM>";

    $form .="\n<FORM name='cancel' method='post' action='install.php'>";
    $form .="\n<TABLE>";
    $form .="<tr>";
    $form .="<td>";
    $form .="<input type='hidden' name=message value='Cancelled'>";
    $form .="<input type=submit value='Cancel'/>";
    $form .="</td>";
    $form .="</tr>";
    $form .="\n</TABLE>";
    $form .="\n</FORM>";
    
    $form .="\n</DIV>";
    return $form;

}

function getWebServerSubform() {
    global $webserver_name, $webserver_port, $install_dir, $urlpath, $attachmentpath;
    $form = "";    
    $form .="\n<TR><TD colspan=2>";
    $form .="<hr><p class=header2>Server Information:</p><p>The default values for this section are usually adequate. They are determined automatically. Only change them if you are sure the displayed value is wrong.";
    $form .="</TD></TR>";

    $form .="\n<TR>";
    $form .="<td><label for=webserver_name>Hostname of Web server:</label></td>";
    $form .="<td align=right><input type=text cols=30 name=webserver_name value='".$webserver_name."'></td>";
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'/>(Unsure? Leave default value)</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";
    
    $form .="\n<TR>";
    $form .="<td><label for=webserver_port>Web server port number:</label></td>";
    $form .="<td align=right><input type=text cols=30 name=webserver_port value='".$webserver_port."'></td>";
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>(Unsure? Leave default value)</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";
    
    $form .="\n<TR>";
    $form .="<td><label for=install_dir>Directory on web server where Aigaion files have been placed:</label></td>";
    $form .="<td align=right><input type=text cols=30 name=install_dir value='".$install_dir."'></td>"; //assuming install script runs in root of aigaion
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>(Don't change unless you are REALLY sure you know what you are doing!)</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";

    $form .="\n<TR>";
    $form .="<td><label for=attachmentpath>Relative directory on web server where attachments will be stored:</label></td>";
    $form .="<td align=right>&lt;install_dir&gt;/<input type=text cols=30 name=attachmentpath value='".$attachmentpath."'></td>"; 
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>(Unsure? Leave default value)</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";
    
    $form .="\n<TR>";
    $form .="<td><label for=urlpath>Path part of URL people have to type in the address bar to access this copy of Aigaion:</label></td>";
    $form .="<td align=right><nobr>http://&lt;webserver name&gt;<input type=text cols=30 name=urlpath value='".$urlpath."'></nobr></td>"; 
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>(Don't change unless you are REALLY sure you know what you are doing!)</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";
//the above one, as wel as the $URL thing, should probably just be set automatically without allowing user intervention.
    
    return $form;
}
        
function getDatabaseAndUserSubform() {
    global $mysql_host, $mysql_database, $create_schema, $create_user, $create_tables, $rootuser, $rootpwd, $aigaionuser, $aigaionpwd;
    $form = "";    
    $form .="\n<TR><TD colspan=2>";
    $form .="<hr><p class=header2>MySql Database Information:</p>";
    $form .="<p>In this section you specify the relevant information about the MySql server.";
    $form .=" If you have been provided by your administrator with a user name and password for ";
    $form .="an existing database, you use those values. If a new database and mysql user need to be ";
    $form .="created, you should check the relevant checkbox and also specify the ROOT access to the";
    $form .=" MySql server. If you don't have that password, and still think the database and user";
    $form .=" need to be created, ask you administrator for help.";
    $form .="</TD></TR>";

    $form .="\n<TR>";
    $form .="<td><label for=mysql_host>Hostname of MySql server:</label></td>";
    $form .="<td align=right><input type=text cols=30 name=mysql_host value='$mysql_host'></td>";
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>(Usually 'localhost')</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";
    
    $form .="\n<TR>";
    $form .="<td><label for=mysql_database>Database name:</label></td>";
    $form .="<td align=right><input type=text cols=30 name=mysql_database value='$mysql_database'></td>";
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>(e.g. aigaion)</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";

    $form .="\n<TR>";
    $form .="<td><label for=aigaionuser>MySql user name:</label></td>";
    $form .="<td align=right><input type=text cols=30 name=aigaionuser value='$aigaionuser'></td>";
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>(e.g. aigaion_user)</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";

    $form .="\n<TR>";
    $form .="<td><label for=aigaionpwd>MySql user password:</label></td>";
    $form .="<td align=right><input type=password cols=30 name=aigaionpwd value=''></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";

    $form .="\n<TR>";
    $form .="<td><label for=aigaionpwd2>Retype MySql user password:</label></td>";
    $form .="<td align=right><input type=password cols=30 name=aigaionpwd2 value=''></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";


    $form .="\n<TR><TD colspan=2>";
    $form .="<input type=hidden name=create_tables value='TRUE'>";
    $form .="<hr><p class=header2>MySql Database Information Advanced:</p>";
    $form .="The install script will build the tables of the database. If database and/or user still need to be created, this can be indicated here.";
    $form .=" In that case, a ROOT username and password for the MySql server is also needed.";
    $form .=" If your administrator provided you with a database name, user name and password, you can probably skip this subsection.</td>";
    $form .="</TR>";

    $form .="\n<TR>";
    $form .="<td><label for=create_schema>Create database before installation:</label></td>";
    $form .="<td align=right><input type=checkbox $create_schema name=create_schema></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";
            
    $form .="\n<TR>";
    $form .="<td><label for=create_user>Create database user before installation:</label></td>";
    $form .="<td align=right><input type=checkbox $create_user name=create_user></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";

    $form .="\n<TR>";
    $form .="<td><label for=rootuser>MySql ROOT user name:</label></td>";
    $form .="<td align=right><input type=text cols=30 name=rootuser value=''></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";

    $form .="\n<TR>";
    $form .="<td><label for=rootpwd>MySql ROOT user password:</label></td>";
    $form .="<td align=right><input type=password cols=30 name=rootpwd value=''></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";

    return $form;
}

?>