<?php 
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/displays/topicdisplays.php");
include_once($DIR."lib/functions/topicfunctions.php");
?>

<script>
var responseSilentSuccess = function(o)
{
   //alert(o.responseText);
}
var responseFailure = function(o)
{
   alert(o.statusText);
}
var callbackSilent =
{
   success : responseSilentSuccess,
   failure : responseFailure
};
</script>


<?php 


//-----------------------------------------------------------------------------------------------------------
function getTopicOptionItem($topic_id,$level,$hasChildren, $callbackparams)
{
    $retString = "";
    $retString.= "<option value=".$topic_id." ";
	//echo $select;
	if ($topic_id==$callbackparams['select']) 
	{
	    $retString.='selected="true" ';
	}
	$retString.=">";
	for($i = 0; $i < $level; $i++)
	{
	    $retString.=$callbackparams['buildtoken'];
	}
	
	
	$retString.=getTopicName($topic_id)."</option>\n";
	return $retString;
}

// De select die hier nu is zit moet in de nieuwe manier naar de callback functie worden verplaatst
function getTopicOptionTree($topicTree, $select = -1, $buildspace="", $buildtoken="&nbsp;&nbsp;")
{
    return getTreeDraw($topicTree,'getTopicOptionItem',array('select' => $select,'buildtoken' => $buildtoken), false);    
}
//-----------------------------------------------------------------------------------------------------------

function getTopicMainItem($topic_id,$level,$hasChildren, $callbackparams)
{
    $result = "";
  
    $result.="<span class=\"small\">";
    if (haveRights("EDIT"))
    { //editors  can edit or remove; 
        if ($callbackparams["showeditlinks"] && ($topic_id != getTopTopic())) {
            $result.=getLinkToTopicEditPage($topic_id, True);
        }
        if ($callbackparams["showdeletelinks"]) {            
            $result.=getLinkToTopicDeletePage($topic_id, (!($hasChildren))); //no delete if haschildren ;
        }
    }
    $result.="</span>&nbsp;";
    if ($row["star"] > 0) {
        $result.="<span class=starred>".(getLinkToTopicPage($topic_id, getTopicName($topic_id), getTopicName($topic_id)))."</span>";
    } else {
        $result.=getLinkToTopicPage($topic_id, getTopicName($topic_id), getTopicName($topic_id));
    }
    $result.= " <span class=verysmallgray>  ".getNrPubReadForTopic($topic_id)."/".getNrPubForTopic($topic_id)."</span>";       

    return $result;
        
}

//collapsed
function topicMainIsCollapsed($topic_id)
{
    $person_id = $_SESSION['personID'];
    $Q = mysql_query("SELECT collapsed FROM persontopic WHERE persontopic.topic_id=".$topic_id." AND persontopic.person_id=".$person_id);
    $R = mysql_fetch_array($Q);
    
    if ($R['collapsed'] > 0) return true;
    return false;    
}

function getTopicMainTree($topicTree, $level,$collapsible, 
                            $showdeletelinks=false, 
                            $showsubscribelinks=false, 
                            $showunsubscribelinks=false, 
                            $showeditlinks=true,
                            $showsearchbox=false) 
{
    $retString = "";
    
    if ($showsearchbox)
    {
        $retString.= getJavaScriptSearch();
        $retString.='<INPUT id="searchinput" type=text onkeyup="SubjectSearch();" name=inputtext size=50><BR>'."\n";
    }
    //function getTreeDraw($tree,$callback, $callbackparams = array(), $managed = true, $level = 0, $collapsible = false,     //$testcollapsecallback = '', $hasdocollapsecallback = false, $docollapsecallback = '', $showsearchbox = false)
    $retString.= getTreeDraw($topicTree,'getTopicMainItem',array('showdeletelinks' => $showdeletelinks,'showsubscribelinks' => $showsubscribelinks,'showunsubscribelinks' => $showunsubscribelinks,'showeditlinks' => $showeditlinks),true, $level,$collapsible,'topicMainIsCollapsed', $collapsible, 'topicMainCollapseCallback', $showsearchbox);
    return $retString;
}

//-----------------------------------------------------------------------------------------------------------
function getTopicSubscribeItem($topic_id,$level,$hasChildren, $callbackparams)
{
    $retString = "";    
    $retString.=' <span class="islink" onclick="javascript:ToggleSubscribeTopic('.$topic_id.')" >';
    if (getIsSubscribedForTopic($topic_id))
        $retString.= '<span id="bold_'.$topic_id.'" class="starred" >'; 
    else
        $retString.= '<span id="bold_'.$topic_id.'" class="" >';   
    $retString.= getTopicName($topic_id)."</span>\n";    
    $retString.= "</span>";
    return $retString;
}


//collapsed
function topicSubscribeIsCollapsed($topic_id)
{
    return false;
}


// gets topic tree with all subscribed things bold with (un) subscribe links.
function getTopicSubscribeTree($topicTree, $level)
{
    return getTreeDraw($topicTree,'getTopicSubscribeItem',array(),true,$level,true,'topicSubscribeIsCollapsed');
}


//-----------------------------------------------------------------------------------------------------------

function getTopicChooseItem($topic_id,$level,$hasChildren, $callbackparams)
{
    $retString = "";
    $retString.=' <span class="islink" onclick="javascript:AddTopic('.$topic_id.')" >';		
    $retString.= getTopicName($topic_id)."</span>\n";
    return $retString;
}


//collapsed
function topicChooseIsCollapsed($topic_id)
{
    return true;
}


/*
creates the printed tree from a root with children of "1" expanded
function drawTree($tree,$callback, $callbackparams = array(), $managed = true, $level = 0, $collapsible = false, $collapsecallback = '')
*/
function getTopicChooseTree($topicTree, $buildspace="", $buildtoken="&nbsp;&nbsp;&nbsp;&nbsp;")
{
    return getTreeDraw($topicTree,'getTopicChooseItem',array(),true, 0,true,'topicChooseIsCollapsed');
	
   
}

//-----------------------------------------------------------------------------------------------------------

function getTopicSimpleItem($topic_id,$level,$hasChildren, $callbackparams)
{    
	$retString = "";
    $retString.= '<A HREF="'.getTopicLink($topic_id).'">'.getTopicName($topic_id).'</A>';
    return $retString;
        
}


function getTopicSimpleTree($topicTree, $buildspace="", $buildtoken="&nbsp;&nbsp;")
{
    return getTreeDraw($topicTree,'getTopicSimpleItem',array(),true, 0,false);	
}

//-----------------------------------------------------------------------------------------------------------

/*
* Makes an array with topic and all parents, in a line
*/
function makeTopicArray($topic, $buildarray = array())
{
	$retArray = $buildarray;
	$Q1=mysql_query("SELECT * FROM topictopiclink WHERE source_topic_id=$topic");
	if ((mysql_num_rows($Q1) > 0))
	{
		$R1=mysql_fetch_array($Q1);
		$retArray[] = $topic;
		return makeTopicArray($R1['target_topic_id'],$retArray);
	}
	else
	{
		$retArray[] = $topic;
		return $retArray;
	}
}



/*
TODO: Only takes one parent, construct array hierarchy form
Takes a variable root, if the root is reached, it stops 
(can lead to strange behaviour when the root is not a parent from aome of the topics) 
*/
function makeTopicLine($topic,$buildarray, $root = 1)
{
	//echo $topic;
	$Q1=mysql_query("SELECT * FROM topictopiclink WHERE source_topic_id=$topic");
	echo mysql_error();
	if ((mysql_num_rows($Q1) > 0) && ($topic != $root))
	{
		$R1=mysql_fetch_array($Q1);
		if ($buildarray != -1)
		{
			return makeTopicLine($R1['target_topic_id'],array($topic => array($buildarray)),$root);
		}
		else
		{
			return makeTopicLine($R1['target_topic_id'],$topic,$root);
		}
	}
	else
	{
		if ($buildarray != -1)
		{ 
			return array(array($topic => array($buildarray)));
		}
		else
		{
			return array($topic);
		}
	}
}

function mergeTopicTree($tree, $line)
{
	if (count($tree) < 1)
	{
		return $line;
	}
	else
	{

		// het gaat erom of de value al voorkomt between de values 
		reset($line);
		list($linekey,$linevalue) = each($line);
		reset($tree);
		$rettree = array();
		$contains = false;
		while (list($key, $val) = each($tree))
	        {
			if (is_array($val))
			{
				if (is_array($linevalue))
				{
					reset($linevalue);
					reset($val);
					list($linekey2,$linevalue2) = each($linevalue);
					list($treekey2,$treevalue2) = each($val);
					if ($treekey2 == $linekey2)
					{
						$rettree[] = array($treekey2 => mergeTopicTree($treevalue2,$linevalue2));
						$contains = true;
					}
					else
					{
						$rettree[] = $val;
					}
				}
				else
				{
					reset($val);
					list($treekey2,$treevalue2) = each($val);
					if ($treekey2 == $linevalue)
					{
						$contains = true;
					}
					$rettree[] = $val;
				}
			}
			else
			{
				if (is_array($linevalue))
				{
					reset($linevalue);
					list($linekey2,$linevalue2) = each($linevalue);
					if ($val == $linekey2)
					{
						$rettree[] = $linevalue;
						$contains=true;
					}
					else
					{
						$rettree[] = $val;
					}
				}
				else
				{
					if ($val == $linevalue)
					{
						$contains=true;
					}
					$rettree[] = $val;
				}
			}
		}
		if ($contains == false)
		{
			$rettree[] = $linevalue;
		}
	}
	return $rettree;
}

			

function makeTopicTree($inputArray, $root = 1)
{
	$retTopicTree = array();
	while (list($key, $val) = each($inputArray)) 
	{
		$retTopicTree = mergeTopicTree($retTopicTree, makeTopicLine($val, -1, $root));
		//print_r(makeTopicLine($val, -1));
	}
	return $retTopicTree;
}


function getTopicName($number)
{
	$Q = mysql_query("SELECT name FROM topic WHERE ID=$number");
	$R = mysql_fetch_array($Q);
	return $R['name'];
}


function getTopicLink($number)
{
	return "index.php?page=topic&topic_id=".$number;
}

/*
    Get leaves (recursive)
*/
function getLeavesRecursive($root, $subscribed = true)
{
    $retArray = array();
    if ($subscribed)
    {
        $person_id = $_SESSION['personID'];
        $Q1=mysql_query("SELECT source_topic_id FROM topictopiclink,persontopic,topic WHERE target_topic_id=$root AND persontopic.topic_id=source_topic_id AND persontopic.person_id=$person_id AND source_topic_id = topic.ID ORDER BY topic.name ASC");
    }
    else
    {
        $Q1=mysql_query("SELECT source_topic_id FROM topictopiclink WHERE target_topic_id=$root");
    }
    //get children
    if (mysql_num_rows($Q1) <= 0)
    {
        //no children
        $retArray[] = $root;
    }
    else
    {
        while ($R1 = mysql_fetch_array($Q1))
        {
            $retArray = array_merge($retArray,getLeavesRecursive($R1['source_topic_id']));
        }
    }
    return $retArray;
}

/*
Makes tree of (subscribed childs) without including the root, help function (actual work, for makeChildTree
*/
function makeChildTreeRec($root, $subscribed = true)
{    
    if ($subscribed)
    {
        //get subscribed children
        $person_id = $_SESSION['personID'];
        $Q1=mysql_query("SELECT source_topic_id FROM topictopiclink,persontopic,topic WHERE target_topic_id=$root AND persontopic.topic_id=source_topic_id AND persontopic.person_id=$person_id AND source_topic_id = topic.ID ORDER BY topic.name ASC");
    }
    else
    {
        //get all children
        $Q1=mysql_query("SELECT source_topic_id FROM topictopiclink,topic WHERE target_topic_id=$root AND source_topic_id = topic.ID ORDER BY topic.name ASC");
    }
    if (mysql_num_rows($Q1) <= 0)
    {
        //no children
        return $root;
        
        
    }
    else
    {
        $retarray = array();
        while ($R1 = mysql_fetch_array($Q1))
        {
            //$retArray = array_merge($retArray,getLeavesRecursive($R1['source_topic_id']));
            $retarray[] = makeChildTreeRec($R1['source_topic_id'],$subscribed);
            //echo $R1['source_topic_id'];
        }
        return array($root => $retarray);
    }    
} 
/*
Makes tree of (subscribed childs) without including the root, function to call
*/
function makeChildTree($root, $subscribed = true)
{    
    $retArray = array();
    $retArray[] =  makeChildTreeRec($root, $subscribed);        
    return $retArray;
} 
    

function removeRoot($tree,$root)
{    
    return $tree[0][$root];	
}

/*
Eerste verschil: krijgt altijd tree
haschildren + collapsed
if buildspace = '' then we work with a div
ident: how many extra buildspace per level OR how many space in the divs
managed: if managed then the drawTree takes care of the divs
*/
function getTreeDraw($tree,$callback, $callbackparams = array(), $managed = true, $level = 0, $collapsible = false, $testcollapsecallback = '', $hasdocollapsecallback = false, $docollapsecallback = '', $showsearchbox = false)
{           
    //print_r($tree);
    $retString = "";
    if (!$tree) {
        return "";
    }
    reset($tree);
	while (list($key, $val) = each($tree))
	{
		if (is_array($val))
		{
			reset($val);
			list($topicnr,$dummy)=each($val);
		}
		else
		{
			$topicnr = $val;
		}
		if ($managed)
		{
		    $retString.="<div style='margin-left: ".(($level)*15)."px'>\n"; 
		    $retString.="<div name=\"self".$topicnr."\" id=\"self".$topicnr."\" >\n";
        }
        
        if ($collapsible) 
        { //Everyone can collapse topics... if collapsible is false, the collapse link isn't shown at all.. otherwise it will be ACTIVE only if the topic has visible children.
            $retString.= getCollapseLinkForTopic($topicnr, $testcollapsecallback($topicnr), is_array($val),$hasdocollapsecallback, $docollapsecallback,$showsearchbox);
        }
		
		
		$retString.= $callback($topicnr,$level,is_array($val),$callbackparams);
		$retString.= "\n";
		
		if ($managed)
		{
		    $retString.= "</div>\n ";
		    $retString.= "</div>\n ";
		}
		if ($collapsible > 0)
		{
		    if ($testcollapsecallback($topicnr))
		    {
		        //return true;
		        
		         
		        $retString.= "<div name=\"children".$topicnr."\" id=\"children".$topicnr."\" class=\"collapsed\">";
		    }
		    else
		    {
		       // collapsable, not collapsed
		       $retString.= "<div name=\"children".$topicnr."\" id=\"children".$topicnr."\" class=\"expanded\">";
		    }
	    }
		if (is_array($val))
		{
		    
			reset($val);
			list($topicnr,$dummy)=each($val);
			$retString.= getTreeDraw($dummy,$callback,$callbackparams, $managed, $level+1, $collapsible, $testcollapsecallback,$hasdocollapsecallback, $docollapsecallback,$showsearchbox);
		}
		
		if ($collapsible > 0)
		{
		    $retString.= "</div>";
	    }	   
	}
	return $retString;
}
/*
Todo: hier ben ik 4/4: we hebben natuurlijk een verschil tussen altijd standaard gecollapsde topics en gecollapsed in database

*/


/*
Input: id of topic, current collapsed state, and if collapse should be active / used (e.g. not active: if it is leaf, or if $collapsible was false)
Output: an effective collapse link.
*/
function getCollapseLinkForTopic($id, $collapsed, $active,$hasdocollapsecallback, $docollapsecallback) {    
    global $URL;
    global $THEME;
    if (!$active)  {
        return "<IMG SRC=\"".$URL.$THEME."icons/_collapse_inactive_small.gif\" border=0>";
    }
    $asynclink = '';
    if ($hasdocollapsecallback)
    {
        $asyncpluslink = "YAHOO.util.Connect.asyncRequest('GET','asynctreescripts.php?f=".$docollapsecallback."&topic_id=".$id."&collapse=0',callbackSilent);";
        $asyncminlink = "YAHOO.util.Connect.asyncRequest('GET','asynctreescripts.php?f=".$docollapsecallback."&topic_id=".$id."&collapse=1',callbackSilent);";        
    }
    $class1="collapsed";
    $class2="expanded";
    if ($collapsed) { 
        $class1="expanded";
        $class2="collapsed";
    }
    
    //plus icon
    $result.="<span class=\"".$class1."\" id=\"expandaction_topic".$id."\" name=\"expandaction_topic".$id."\" onclick=\"javascript:document.getElementById('children".$id."').className='expanded';document.getElementById('expandaction_topic".$id."').className='collapsed';document.getElementById('collapseaction_topic".$id."').className='expanded';".$asyncpluslink."\">";           
      $result.="<IMG SRC=\"".$URL.$THEME."icons/_expand_small.gif\" class=islink border=0>";      
    $result.="</span>";
    
    
    //minus icon
    $result.="<span class=\"".$class2."\" id=\"collapseaction_topic".$id."\" name=\"collapseaction_topic".$id."\" onclick=\"javascript:document.getElementById('children".$id."').className='collapsed';document.getElementById('expandaction_topic".$id."').className='expanded';document.getElementById('collapseaction_topic".$id."').className='collapsed';".$asyncminlink."\">";         
      $result.="<IMG SRC=\"".$URL.$THEME."icons/_collapse_small.gif\" class=islink border=0>";      
    $result.="</span>";

    return $result;
}

//Generate topic structure
function getjavatopics($busy = 1, $level = 0, $parent = 0, $subscribed = true)
{
        $retString = '';
        //current
        $Q1 = mysql_query("SELECT * FROM topic WHERE ID=$busy");
        $R1 = mysql_fetch_array($Q1);
	    $retString.= 'SUBJECTS['.$R1['ID'].'] = ';
        //childs
	    $person_id = $_SESSION['personID']; 
	    if ($subscribed)
	    {
            $Q2 = mysql_query("SELECT * FROM topic, topictopiclink, persontopic WHERE target_topic_id=$busy AND topictopiclink.source_topic_id = topic.ID AND persontopic.person_id=$person_id AND persontopic.topic_id=topic.ID");
        }
        else
        {
            $Q2 = mysql_query("SELECT * FROM topic, topictopiclink WHERE target_topic_id=$busy AND topictopiclink.source_topic_id = topic.ID");
        }
        $retString.= mysql_error();
        if (mysql_num_rows($Q2) > 0)
        {
		$retString.= '["';
		$retString.= $R1['name'];
		$retString.= '",[';
		if ($R2 = mysql_fetch_array($Q2))
		{
			$retString.= $R2['ID'];
			while ($R2 = mysql_fetch_array($Q2))
			{
				$retString.= ','.$R2['ID'];
			}
		}
		$retString.= '],'.$level.','.$parent.'];'."\n";
		if ($subscribed)
		{
		    $Q3 = mysql_query("SELECT * FROM topic, topictopiclink, persontopic  WHERE target_topic_id=$busy AND topictopiclink.source_topic_id = topic.ID AND persontopic.person_id=$person_id AND persontopic.topic_id=topic.ID");
		}
		else
		{
		    $Q3 = mysql_query("SELECT * FROM topic, topictopiclink  WHERE target_topic_id=$busy AND topictopiclink.source_topic_id = topic.ID");
		}
		while ($R3 =  mysql_fetch_array($Q3))
		{
			 $retString.= getjavatopics($R3['ID'],($level + 1), $busy, $subscribed);
		 }
	}
	else
	{
		$retString.= '["'.$R1['name'].'",'.$parent.'];'."\n";
	}
	return $retString;
}
function getJavaScriptSearch()
{
    $person_id = $_SESSION['personID'];
    $retString = '';
    $retString .=  '<SCRIPT LANGUAGE="JavaScript"> '."\n";
    $retString .=  'var SUBJECTS = { };'."\n";
    
    $retString .= getjavatopics(1);
    $retString .=  'var SUBJECTNAMES = { };'."\n";
    $Q = mysql_query("SELECT topic.ID,name FROM topic, persontopic WHERE  persontopic.topic_id=topic.ID AND persontopic.person_id=".$person_id." AND ID > 1  ORDER BY ID");
    $retString .= mysql_error();
    while ($R = mysql_fetch_array($Q))
    {
    	$retString .= 'SUBJECTNAMES['.$R["ID"].'] = "'.addslashes($R["name"]).'";'."\n";    	
    }
    $retString .= 'function El(id) {'."\n";
    $retString .= '    return document.getElementById(id);'."\n";
    $retString .= '}'."\n";
    $retString .= 'function GetParent(id)'."\n";
    $retString .= '{'."\n";
    $retString .= '	if (HasSubcategories(id))'."\n";
    $retString .= '	{'."\n";
	$retString .= '	    return SUBJECTS[id][3];'."\n";
	$retString .= '    }'."\n";
	$retString .= '    else'."\n";
	$retString .= '    {'."\n";
    $retString .= '		return SUBJECTS[id][1];'."\n";
    $retString .= '	}'."\n";
    $retString .= '}'."\n";
    $retString .= 'function ParentExpand(id)'."\n";
    $retString .= '{'."\n";
    $retString .= '    if (id > 1)'."\n";    
    $retString .= '    {'."\n";        
    $retString .= '        El("self"+id).className = \'expanded\';'."\n";    
    $retString .= '        if (HasSubcategories(id))'."\n";
    $retString .= '        {'."\n";
    $retString .= '            if (El("children"+id).className == \'invisibleexpanded\')'."\n";
    $retString .= '            {'."\n";
    $retString .= '                 El("children"+id).className = \'expanded\';'."\n";
    $retString .= '            }'."\n";
    $retString .= '            if (El("children"+id).className == \'collapsed\')'."\n";
    $retString .= '            {'."\n";
    $retString .= '                 El("children"+id).className = \'visiblecollapsed\';'."\n";
    $retString .= '            }'."\n";
    $retString .= '        }'."\n";
    $retString .= '        ParentExpand(GetParent(id));'."\n";
    $retString .= '    }'."\n";
    $retString .= '}'."\n";
    
    $retString .= 'function HasSubcategories(id) {'."\n";  
    $retString .= ' return (SUBJECTS[id].length > 2);'."\n";
    $retString .= '}'."\n";
    $retString .= 'function SubjectSearch()'."\n";
    $retString .= '{'."\n";
    $retString .= 'var searchtext = El("searchinput").value;'."\n";
    $retString .= 'if (searchtext == "")'."\n";
    $retString .= '{'."\n";
    $retString .= '    for(a in SUBJECTNAMES)'."\n";
    $retString .= '    {'."\n";        
    $retString .= '        El("self"+a).className = \'expanded\';'."\n";    
    $retString .= '        if (HasSubcategories(a))'."\n";
    $retString .= '        {'."\n";    
    $retString .= '            if (El("children"+a).className == \'invisibleexpanded\')'."\n";
    $retString .= '            {'."\n";
    $retString .= '                El("children"+a).className = \'expanded\';'."\n";
    $retString .= '            }'."\n";
    $retString .= '            if (El("children"+a).className == \'visiblecollapsed\')'."\n";
    $retString .= '            {'."\n";
    $retString .= '                El("children"+a).className = \'collapsed\';'."\n";
    $retString .= '            }'."\n";
    $retString .= '        }'."\n";
    $retString .= '    }'."\n";
    $retString .= '}'."\n";
    $retString .= 'else'."\n";
    $retString .= '{'."\n";
    $retString .= '    for(a in SUBJECTNAMES)'."\n";
    $retString .= '    {'."\n";
    $retString .= '        El("self"+a).className = \'invisibleexpanded\';'."\n";        
    $retString .= '        if (HasSubcategories(a))'."\n";
    $retString .= '       {'."\n";    
    $retString .= '            if (El("children"+a).className == \'expanded\')'."\n";
    $retString .= '             {'."\n";
    $retString .= '                 El("children"+a).className = \'invisibleexpanded\';'."\n";
    $retString .= '             }'."\n";
    $retString .= '            if (El("children"+a).className == \'visiblecollapsed\')'."\n";
    $retString .= '             {'."\n";
    $retString .= '                 El("children"+a).className = \'collapsed\';'."\n";
    $retString .= '             }'."\n";
    $retString .= '        }'."\n";            
    $retString .= '    }'."\n";
	$retString .= '    for(a in SUBJECTNAMES)'."\n";
	$retString .= '    {'."\n";
	$retString .= '        var astring = new String(SUBJECTNAMES[a]);'."\n";
	$retString .= '	    if (astring.toUpperCase().indexOf(searchtext.toUpperCase()) != -1)'."\n";
	$retString .= '	    {'."\n";
	$retString .= '	        ParentExpand(a);'."\n";
	$retString .= '	    }'."\n";        
	$retString .= '	}'."\n";
    $retString .= '}'."\n";
    $retString .= '}'."\n";
    
    $retString .= '</SCRIPT>'."\n";
    return $retString;
}

?>